/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings.tab;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.config.entry.BooleanConfigEntry;
import su.plo.config.entry.ConfigEntry;
import su.plo.config.entry.EnumConfigEntry;
import su.plo.config.entry.IntConfigEntry;
import su.plo.lib.mod.client.ResourceLocationUtil;
import su.plo.lib.mod.client.gui.components.Button;
import su.plo.lib.mod.client.gui.components.IconButton;
import su.plo.lib.mod.client.gui.widget.GuiAbstractWidget;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.slib.api.chat.style.McTextStyle;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.capture.ClientActivation;
import su.plo.voice.api.client.audio.capture.ClientActivationManager;
import su.plo.voice.api.client.config.hotkey.Hotkey;
import su.plo.voice.api.client.connection.ServerInfo;
import su.plo.voice.api.client.event.audio.capture.ClientActivationRegisteredEvent;
import su.plo.voice.api.client.event.audio.capture.ClientActivationUnregisteredEvent;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.client.audio.capture.VoiceClientActivation;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.config.capture.ConfigClientActivation;
import su.plo.voice.client.config.hotkey.HotkeyConfigEntry;
import su.plo.voice.client.extension.TextKt;
import su.plo.voice.client.gui.settings.VoiceSettingsScreen;
import su.plo.voice.client.gui.settings.tab.AbstractHotKeysTabWidget;
import su.plo.voice.client.gui.settings.tab.TabWidget;
import su.plo.voice.client.gui.settings.widget.CompositeRowWidget;
import su.plo.voice.client.gui.settings.widget.DistanceSliderWidget;
import su.plo.voice.client.gui.settings.widget.DropDownWidget;
import su.plo.voice.client.gui.settings.widget.HotKeyWidget;
import su.plo.voice.client.gui.settings.widget.NumberTextFieldWidget;
import su.plo.voice.proto.data.audio.capture.Activation;
import su.plo.voice.proto.data.audio.capture.VoiceActivation;

public final class ActivationTabWidget
extends AbstractHotKeysTabWidget {
    private static final List<McTextComponent> TYPES = ImmutableList.of((Object)McTextComponent.translatable("gui.plasmovoice.activation.type_ptt", new Object[0]), (Object)McTextComponent.translatable("gui.plasmovoice.activation.type_voice", new Object[0]), (Object)McTextComponent.translatable("gui.plasmovoice.activation.type_inherit", new Object[0]));
    private static final List<McTextComponent> NO_INHERIT_TYPES = ImmutableList.of((Object)McTextComponent.translatable("gui.plasmovoice.activation.type_ptt", new Object[0]), (Object)McTextComponent.translatable("gui.plasmovoice.activation.type_voice", new Object[0]));
    private final ClientActivationManager activations;
    private Map<UUID, Set<UUID>> activationConflicts;

    public ActivationTabWidget(@NotNull VoiceSettingsScreen parent, @NotNull PlasmoVoiceClient voiceClient, @NotNull VoiceClientConfig config) {
        super(parent, voiceClient, config);
        this.activations = voiceClient.getActivationManager();
    }

    @Override
    public void init() {
        super.init();
        Map<UUID, Set<UUID>> proximityConflicts = this.detectActivationConflicts(true);
        Map<UUID, Set<UUID>> nonProximityConflicts = this.detectActivationConflicts(false);
        HashMap conflicts = Maps.newHashMap();
        conflicts.putAll(proximityConflicts);
        conflicts.putAll(nonProximityConflicts);
        this.activationConflicts = conflicts;
        this.activations.getParentActivation().ifPresent(activation -> this.createActivation((ClientActivation)activation, false));
        ArrayList activations = Lists.newArrayList(this.activations.getActivations());
        Collections.reverse(activations);
        activations.stream().filter(activation -> !activation.getId().equals(VoiceActivation.PROXIMITY_ID)).forEach(activation -> this.createActivation((ClientActivation)activation, true));
    }

    @EventSubscribe
    public void onActivationRegister(@NotNull ClientActivationRegisteredEvent event) {
        Minecraft.getInstance().execute(this::init);
    }

    @EventSubscribe
    public void onActivationUnregister(@NotNull ClientActivationUnregisteredEvent event) {
        Minecraft.getInstance().execute(this::init);
    }

    private Map<UUID, Set<UUID>> detectActivationConflicts(boolean proximity) {
        HashMap conflicts = Maps.newHashMap();
        ArrayList allActivations = Lists.newArrayList(this.activations.getActivations());
        List activationsToCheck = allActivations.stream().filter(activation -> activation.isProximity() == proximity).sorted(Comparator.comparingInt(Activation::getWeight)).collect(Collectors.toList());
        if (activationsToCheck.size() < 2) {
            return conflicts;
        }
        for (int i = 0; i < activationsToCheck.size(); ++i) {
            ClientActivation current = (ClientActivation)activationsToCheck.get(i);
            Set currentConflicts = conflicts.getOrDefault(current.getId(), Sets.newHashSet());
            for (int j = i + 1; j < activationsToCheck.size(); ++j) {
                ConfigClientActivation currentConfig;
                ConfigClientActivation higherConfig;
                ClientActivation higher = (ClientActivation)activationsToCheck.get(j);
                if (higher.isTransitive() || (higherConfig = (ConfigClientActivation)this.config.getActivations().getActivation(higher.getId()).orElse(null)) == null || (currentConfig = (ConfigClientActivation)this.config.getActivations().getActivation(current.getId()).orElse(null)) == null) continue;
                ClientActivation.Type higherType = (ClientActivation.Type)((Object)higherConfig.getConfigType().value());
                ClientActivation.Type currentType = (ClientActivation.Type)((Object)currentConfig.getConfigType().value());
                if (higherType == ClientActivation.Type.PUSH_TO_TALK && currentType == ClientActivation.Type.PUSH_TO_TALK) {
                    VoiceClientActivation higherVoice = (VoiceClientActivation)higher;
                    VoiceClientActivation currentVoice = (VoiceClientActivation)current;
                    Hotkey higherKey = (Hotkey)higherVoice.getPttConfigEntry().value();
                    Hotkey currentKey = (Hotkey)currentVoice.getPttConfigEntry().value();
                    if (!higherKey.getKeys().equals(currentKey.getKeys())) continue;
                    currentConflicts.add(higher.getId());
                    continue;
                }
                if (currentType != ClientActivation.Type.VOICE && currentType != ClientActivation.Type.INHERIT || higherType != ClientActivation.Type.VOICE && higherType != ClientActivation.Type.INHERIT) continue;
                currentConflicts.add(higher.getId());
            }
            if (currentConflicts.isEmpty()) continue;
            conflicts.put(current.getId(), currentConflicts);
        }
        return conflicts;
    }

    private void createActivation(ClientActivation activation, boolean canInherit) {
        ServerInfo serverInfo = this.voiceClient.getServerInfo().orElseThrow(() -> new IllegalStateException("Not connected"));
        VoiceClientConfig.Server serverConfig = this.config.getServers().getById(serverInfo.getServerId()).orElseThrow(() -> new IllegalStateException("Not connected"));
        ConfigClientActivation activationConfig = this.config.getActivations().getActivation(activation.getId()).orElseThrow(() -> new IllegalStateException("Activation config is empty"));
        IntConfigEntry activationDistance = serverConfig.getActivationDistance(activation.getId()).orElseThrow(() -> new IllegalStateException("Activation distance config is empty"));
        this.addEntry(new TabWidget.CategoryEntry(this, McTextComponent.translatable(activation.getTranslation(), new Object[0])));
        this.addEntry(this.createActivationType(activation, activationConfig, canInherit));
        this.addEntry(this.createActivationButton((VoiceClientActivation)activation));
        if (activation.getDistances().size() > 0) {
            this.createDistance(activation, activationDistance);
        }
    }

    private TabWidget.OptionEntry<?> createActivationType(@NotNull ClientActivation activation, @NotNull ConfigClientActivation activationConfig, boolean canInherit) {
        int dropdownWidth;
        Set<UUID> conflicts = this.activationConflicts.get(activation.getId());
        boolean hasConflicts = conflicts != null;
        int n = dropdownWidth = activation.getType() == ClientActivation.Type.PUSH_TO_TALK ? 124 : 100;
        if (hasConflicts) {
            dropdownWidth -= 24;
        }
        DropDownWidget dropdown = new DropDownWidget((VoiceSettingsScreen)this.parent, 0, 0, dropdownWidth, 20, TYPES.get(activation.getType().ordinal()), canInherit ? TYPES : NO_INHERIT_TYPES, false, index -> {
            activationConfig.getConfigType().set(ClientActivation.Type.values()[index]);
            this.init();
        });
        IconButton warningIcon = null;
        if (hasConflicts) {
            warningIcon = this.createConflictIcon(activation, conflicts);
        }
        CompositeRowWidget row = new CompositeRowWidget(0, 0, activation.getType() == ClientActivation.Type.PUSH_TO_TALK ? 124 : 100, 20, 4, dropdown, warningIcon);
        return new ActivationToggleStateEntry(this, (McTextComponent)McTextComponent.translatable("gui.plasmovoice.activation.type", new Object[0]), (GuiAbstractWidget)row, (McTextComponent)McTextComponent.translatable(activation.getTranslation(), new Object[0]), activationConfig.getConfigType(), activationConfig.getConfigToggle(), null, (btn, element) -> {
            dropdown.setText(TYPES.get(activation.getType().ordinal()));
            this.init();
        });
    }

    private IconButton createConflictIcon(@NotNull ClientActivation activation, @NotNull Set<UUID> conflicts) {
        McTextComponent conflictingNames = TextKt.join(conflicts.stream().map(this.activations::getActivationById).filter(Optional::isPresent).map(Optional::get).map(Activation::getTranslation).map(x$0 -> McTextComponent.translatable(x$0, new Object[0])).collect(Collectors.toList()), McTextComponent.literal("\", \""));
        IconButton icon = new IconButton(0, 0, 20, 20, button -> {}, (button, context, mouseX, mouseY) -> ((VoiceSettingsScreen)this.parent).setTooltip(McTextComponent.translatable("gui.plasmovoice.activation.conflict", McTextComponent.translatable(activation.getTranslation(), new Object[0]), conflictingNames)), ResourceLocationUtil.mod("textures/icons/warning.png"), false);
        icon.setIconColor(new Color(16434771));
        return icon;
    }

    private TabWidget.OptionEntry<HotKeyWidget> createActivationButton(@NotNull VoiceClientActivation activation) {
        String translatable = "gui.plasmovoice.activation.toggle_button";
        HotkeyConfigEntry entry = activation.getToggleConfigEntry();
        if (activation.getType() == ClientActivation.Type.PUSH_TO_TALK) {
            translatable = "gui.plasmovoice.activation.ptt_button";
            entry = activation.getPttConfigEntry();
        }
        entry.clearChangeListeners();
        entry.addChangeListener(event -> this.init());
        return this.createHotKey(translatable, null, entry);
    }

    private void createDistance(@NotNull ClientActivation activation, @NotNull IntConfigEntry activationDistance) {
        if (activation.getDistances().size() == 0) {
            return;
        }
        if (activation.getMinDistance() == -1) {
            this.addEntry(this.createDistanceText(activation, activationDistance));
        } else {
            this.addEntry(this.createDistanceSlider(activation, activationDistance));
        }
    }

    private TabWidget.OptionEntry<DistanceSliderWidget> createDistanceSlider(@NotNull ClientActivation activation, @NotNull IntConfigEntry activationDistance) {
        DistanceSliderWidget sliderWidget = new DistanceSliderWidget(activation, activationDistance, 0, 0, 124, 20);
        return new TabWidget.OptionEntry((TabWidget)this, (McTextComponent)McTextComponent.translatable("gui.plasmovoice.activation.distance", McTextComponent.translatable(activation.getTranslation(), new Object[0])), (GuiAbstractWidget)sliderWidget, (ConfigEntry)activationDistance);
    }

    private TabWidget.OptionEntry<NumberTextFieldWidget> createDistanceText(@NotNull ClientActivation activation, @NotNull IntConfigEntry activationDistance) {
        NumberTextFieldWidget textField = new NumberTextFieldWidget(activationDistance, 0, 0, 124, 20);
        return new TabWidget.OptionEntry((TabWidget)this, (McTextComponent)McTextComponent.translatable("gui.plasmovoice.activation.distance", McTextComponent.translatable(activation.getTranslation(), new Object[0])), (GuiAbstractWidget)textField, (ConfigEntry)activationDistance);
    }

    private static class ActivationToggleStateEntry<W extends GuiAbstractWidget>
    extends TabWidget.ButtonOptionEntry<W> {
        final /* synthetic */ ActivationTabWidget this$0;

        public ActivationToggleStateEntry(@NotNull McTextComponent text, @NotNull W widget, @NotNull McTextComponent activationName, @NotNull EnumConfigEntry<ClientActivation.Type> entry, @Nullable BooleanConfigEntry stateEntry, @Nullable McTextComponent tooltip, TabWidget.OptionResetAction<W> resetAction) {
            this.this$0 = var1_1;
            super((TabWidget)var1_1, text, widget, (List)Lists.newArrayList(), entry, tooltip, resetAction);
            if (entry.value() == ClientActivation.Type.PUSH_TO_TALK) {
                return;
            }
            IconButton disableToggleState = new IconButton(((VoiceSettingsScreen)((ActivationTabWidget)var1_1).parent).getWidth() - 52, 8, 20, 20, button -> {
                ((Button)this.buttons.get(0)).setVisible(false);
                ((Button)this.buttons.get(1)).setVisible(true);
                stateEntry.set(true);
            }, (button, render, mouseX, mouseY) -> ((VoiceSettingsScreen)this.this$0.parent).setTooltip(McTextComponent.translatable("gui.plasmovoice.activation.toggle", activationName, McTextComponent.translatable("gui.plasmovoice.toggle.currently", McTextComponent.translatable("gui.plasmovoice.toggle.enabled", new Object[0]).withStyle(McTextStyle.GREEN)).withStyle(McTextStyle.GRAY))), ResourceLocation.tryParse((String)"plasmovoice:textures/icons/microphone_menu.png"), true);
            IconButton enableToggleState = new IconButton(((VoiceSettingsScreen)((ActivationTabWidget)var1_1).parent).getWidth() - 52, 8, 20, 20, button -> {
                ((Button)this.buttons.get(0)).setVisible(true);
                ((Button)this.buttons.get(1)).setVisible(false);
                stateEntry.set(false);
            }, (button, render, mouseX, mouseY) -> ((VoiceSettingsScreen)this.this$0.parent).setTooltip(McTextComponent.translatable("gui.plasmovoice.activation.toggle", activationName, McTextComponent.translatable("gui.plasmovoice.toggle.currently", McTextComponent.translatable("gui.plasmovoice.toggle.disabled", new Object[0]).withStyle(McTextStyle.RED)).withStyle(McTextStyle.GRAY))), ResourceLocation.tryParse((String)"plasmovoice:textures/icons/microphone_menu_disabled.png"), true);
            disableToggleState.setVisible((Boolean)stateEntry.value() == false);
            enableToggleState.setVisible((Boolean)stateEntry.value());
            this.buttons.add(disableToggleState);
            this.buttons.add(enableToggleState);
            this.widgets.addAll(this.buttons);
        }
    }
}

