/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.filter;

import com.plasmoverse.rnnoise.Denoise;
import com.plasmoverse.rnnoise.DenoiseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.config.entry.ConfigEntry;
import su.plo.voice.BaseVoice;
import su.plo.voice.api.client.audio.filter.AudioFilter;
import su.plo.voice.api.client.audio.filter.AudioFilterContext;
import su.plo.voice.api.util.AudioUtil;
import su.plo.voice.client.audio.filter.LimiterFilter;
import su.plo.voice.util.NativesKt;

public final class NoiseSuppressionFilter
implements AudioFilter {
    private final ConfigEntry<Boolean> activeEntry;
    private final LimiterFilter limiter;
    @Nullable
    private Denoise instance;

    public NoiseSuppressionFilter(int sampleRate, @NotNull ConfigEntry<Boolean> activeEntry) {
        this.limiter = new LimiterFilter(sampleRate, Float.valueOf(-6.0f));
        this.activeEntry = activeEntry;
        if (!NativesKt.isNativesSupported()) {
            activeEntry.set(false);
            activeEntry.setDisabled(true);
        } else if (activeEntry.value().booleanValue()) {
            this.toggle(true);
        }
        activeEntry.clearChangeListeners();
        activeEntry.addChangeListener(this::toggle);
    }

    private void toggle(boolean value) {
        if (value) {
            try {
                this.instance = Denoise.create();
            }
            catch (Exception | LinkageError e) {
                BaseVoice.LOGGER.error("RNNoise is not available on this platform", new Object[0]);
                this.activeEntry.set(false);
                this.activeEntry.setDisabled(true);
            }
        } else if (this.instance != null) {
            this.instance.close();
            this.instance = null;
        }
    }

    @Override
    @NotNull
    public String getName() {
        return "noise_suppression";
    }

    @Override
    public short[] process(@NotNull AudioFilterContext context, short[] samples) {
        if (this.instance == null) {
            return samples;
        }
        this.limiter.process(context, samples);
        try {
            float[] floats = AudioUtil.shortsToFloats(samples);
            samples = AudioUtil.floatsToShorts(this.instance.process(floats));
            return samples;
        }
        catch (DenoiseException e) {
            throw new RuntimeException("Failed to denoise audio samples", e);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.instance != null && this.activeEntry.value() != false;
    }

    @Override
    public int getSupportedChannels() {
        return 1;
    }
}

