/*
 * Decompiled with CFR 0.152.
 */
package su.plo.slib.libs.adventure.adventure.text.minimessage.tag.resolver;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.slib.libs.adventure.adventure.text.Component;
import su.plo.slib.libs.adventure.adventure.text.minimessage.internal.serializer.ClaimConsumer;
import su.plo.slib.libs.adventure.adventure.text.minimessage.internal.serializer.SerializableResolver;
import su.plo.slib.libs.adventure.adventure.text.minimessage.tag.Tag;
import su.plo.slib.libs.adventure.adventure.text.minimessage.tag.resolver.MappableResolver;
import su.plo.slib.libs.adventure.adventure.text.minimessage.tag.resolver.TagResolver;

final class CachingTagResolver
implements TagResolver.WithoutArguments,
MappableResolver,
SerializableResolver {
    private static final Tag NULL_REPLACEMENT = () -> {
        throw new UnsupportedOperationException("no-op null tag");
    };
    private final Map<String, Tag> cache = new HashMap<String, Tag>();
    private final TagResolver.WithoutArguments resolver;

    CachingTagResolver(TagResolver.WithoutArguments resolver) {
        this.resolver = resolver;
    }

    private Tag query(@NotNull String key) {
        return this.cache.computeIfAbsent(key, k -> {
            @Nullable Tag result2 = this.resolver.resolve((String)k);
            return result2 == null ? NULL_REPLACEMENT : result2;
        });
    }

    @Override
    @Nullable
    public Tag resolve(@NotNull String name) {
        Tag potentialValue = this.query(name);
        return potentialValue == NULL_REPLACEMENT ? null : potentialValue;
    }

    @Override
    public boolean has(@NotNull String name) {
        return this.query(name) != NULL_REPLACEMENT;
    }

    @Override
    public boolean contributeToMap(@NotNull Map<String, Tag> map2) {
        if (this.resolver instanceof MappableResolver) {
            return ((MappableResolver)((Object)this.resolver)).contributeToMap(map2);
        }
        return false;
    }

    @Override
    public void handle(@NotNull Component serializable, @NotNull ClaimConsumer consumer2) {
        if (this.resolver instanceof SerializableResolver) {
            ((SerializableResolver)((Object)this.resolver)).handle(serializable, consumer2);
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CachingTagResolver)) {
            return false;
        }
        CachingTagResolver that = (CachingTagResolver)other;
        return Objects.equals(this.resolver, that.resolver);
    }

    public int hashCode() {
        return Objects.hash(this.resolver);
    }
}

