/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.render.shader;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import lombok.NonNull;
import su.plo.voice.client.ModVoiceClient;
import su.plo.voice.universal.shader.BlendState;
import su.plo.voice.universal.shader.UShader;

public class ShaderUtil {
    public static UShader loadShader(@NonNull String vertName, @NonNull String fragName, @NonNull BlendState blendState) throws IOException {
        if (vertName == null) {
            throw new NullPointerException("vertName is marked non-null but is null");
        }
        if (fragName == null) {
            throw new NullPointerException("fragName is marked non-null but is null");
        }
        if (blendState == null) {
            throw new NullPointerException("blendState is marked non-null but is null");
        }
        return UShader.Companion.fromLegacyShader(ShaderUtil.readShader(vertName, "vsh"), ShaderUtil.readShader(fragName, "fsh"), blendState, DefaultVertexFormat.POSITION_TEX_COLOR);
    }

    private static String readShader(@NonNull String name, @NonNull String ext) throws IOException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (ext == null) {
            throw new NullPointerException("ext is marked non-null but is null");
        }
        try (InputStream is = ModVoiceClient.class.getResource(String.format("/assets/plasmovoice/shaders/%s.%s", name, ext)).openStream();){
            String string = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            return string;
        }
    }
}

