/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.language;

import com.mojang.blaze3d.platform.InputConstants;
import lombok.NonNull;
import net.minecraft.client.Minecraft;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.jetbrains.annotations.NotNull;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.voice.api.client.config.hotkey.Hotkey;

public final class LanguageUtil {
    public static String getOrDefault(String key) {
        return Language.getInstance().getOrDefault(key);
    }

    public static boolean has(String key) {
        return Language.getInstance().has(key);
    }

    public static String getSelectedLanguage() {
        return Minecraft.getInstance().getLanguageManager().getSelected();
    }

    @NotNull
    public static McTextComponent getKeyDisplayName(@NonNull Hotkey.Key key) {
        InputConstants.Key inputKey;
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (key.getType() == Hotkey.Type.KEYSYM) {
            inputKey = InputConstants.Type.KEYSYM.getOrCreate(key.getCode());
        } else if (key.getType() == Hotkey.Type.MOUSE) {
            inputKey = InputConstants.Type.MOUSE.getOrCreate(key.getCode());
        } else if (key.getType() == Hotkey.Type.SCANCODE) {
            inputKey = InputConstants.Type.SCANCODE.getOrCreate(key.getCode());
        } else {
            return McTextComponent.translatable("gui.none", new Object[0]);
        }
        Component displayName = inputKey.getDisplayName();
        if (displayName.getContents() instanceof TranslatableContents) {
            TranslatableContents translatable = (TranslatableContents)displayName.getContents();
            return McTextComponent.translatable(translatable.getKey(), translatable.getArgs());
        }
        if (displayName.getContents() instanceof PlainTextContents.LiteralContents) {
            PlainTextContents.LiteralContents literal = (PlainTextContents.LiteralContents)displayName.getContents();
            return McTextComponent.translatable(literal.text(), new Object[0]);
        }
        return McTextComponent.translatable("gui.none", new Object[0]);
    }

    private LanguageUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

