/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.foundation.copycat.model.neoforge;

import com.copycatsplus.copycats.CCBlockStateProperties;
import com.copycatsplus.copycats.CCBlocks;
import com.copycatsplus.copycats.foundation.copycat.ICopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.ICopycatBlockEntity;
import com.copycatsplus.copycats.foundation.copycat.model.CopycatModelCore;
import com.copycatsplus.copycats.foundation.copycat.model.assembly.neoforge.CopycatRenderContextNeoForge;
import com.copycatsplus.copycats.foundation.copycat.model.neoforge.FilteredBlockAndTintGetterForge;
import com.copycatsplus.copycats.foundation.copycat.model.neoforge.ScaledBlockAndTintGetterForge;
import com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlockEntity;
import com.copycatsplus.copycats.utility.neoforge.ModelDataUtils;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.foundation.model.BakedModelWrapperWithData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.createmod.catnip.data.Iterate;
import net.createmod.ponder.render.VirtualRenderHelper;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.neoforged.neoforge.common.util.TriState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopycatModelNeoForge
extends BakedModelWrapperWithData {
    public static final ModelProperty<BlockState> MATERIAL_PROPERTY = new ModelProperty();
    public static final ModelProperty<Map<String, BlockState>> MATERIALS_PROPERTY = new ModelProperty();
    private static final ModelProperty<Map<String, OcclusionData>> OCCLUSION_PROPERTY = new ModelProperty();
    private static final ModelProperty<Map<String, ModelData>> WRAPPED_DATA_PROPERTY = new ModelProperty();
    private static final ChunkRenderTypeSet allRenderTypes = ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.solid(), RenderType.cutout(), RenderType.cutoutMipped(), RenderType.translucent()});
    protected final CopycatModelCore core;
    private final boolean disableAO;
    protected final List<CopycatModelCore.ModelEntry> entries = new ArrayList<CopycatModelCore.ModelEntry>();
    private final ThreadLocal<RenderSession> renderSession = ThreadLocal.withInitial(() -> new RenderSession(this::getQuads));

    public CopycatModelNeoForge(BakedModel originalModel, CopycatModelCore core, boolean disableAO) {
        super(originalModel);
        this.core = core;
        this.disableAO = disableAO;
        core.registerModels(this.entries);
    }

    public boolean isCustomRenderer() {
        return true;
    }

    public boolean useAmbientOcclusion() {
        if (this.disableAO) {
            return false;
        }
        return super.useAmbientOcclusion();
    }

    @NotNull
    public TriState useAmbientOcclusion(@NotNull BlockState state, @NotNull ModelData data, @NotNull RenderType renderType) {
        if (this.disableAO) {
            return TriState.FALSE;
        }
        return super.useAmbientOcclusion(state, data, renderType);
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        ChunkRenderTypeSet renderTypes = allRenderTypes;
        Map<String, BlockState> materials = CopycatModelNeoForge.getMaterials(data);
        this.prepareModelCore(state, rand, data);
        for (CopycatModelCore.ModelEntry entry : this.entries) {
            BakedModel model;
            BlockState material = materials.get(entry.key());
            if (material == null && entry.type().useCopycatLogic() || (model = this.getModelForEntry(entry, state, material)) == null) continue;
            if (entry.type().useCopycatLogic()) {
                if (material == null) continue;
                renderTypes = ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{renderTypes, model.getRenderTypes(material, rand, data)});
                continue;
            }
            renderTypes = ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{renderTypes, model.getRenderTypes(state, rand, data)});
        }
        return renderTypes;
    }

    public ModelData.Builder gatherModelData(ModelData.Builder builder, BlockAndTintGetter world, BlockPos pos, BlockState state, ModelData blockEntityData) {
        BlockState material;
        Map<String, BlockState> materials;
        if (!(this.originalModel instanceof BakedModelWrapperWithData)) {
            ModelDataUtils.copyModelData(this.originalModel.getModelData(world, pos, state, blockEntityData), builder);
        }
        if ((materials = CopycatModelNeoForge.getMaterials(blockEntityData)).isEmpty() && (material = (BlockState)blockEntityData.get(MATERIAL_PROPERTY)) != null) {
            materials = Map.of("material", material);
        }
        if (materials.isEmpty()) {
            return builder;
        }
        builder.with(MATERIALS_PROPERTY, new HashMap<String, BlockState>(materials));
        Block block = state.getBlock();
        if (!(block instanceof ICopycatBlock)) {
            return builder;
        }
        ICopycatBlock copycatBlock = (ICopycatBlock)block;
        if (copycatBlock instanceof IMultiStateCopycatBlock) {
            IMultiStateCopycatBlock multiStateBlock = (IMultiStateCopycatBlock)copycatBlock;
            HashMap<String, ModelData> wrappedDataMap = new HashMap<String, ModelData>();
            HashMap<String, OcclusionData> occlusionMap = new HashMap<String, OcclusionData>();
            for (Map.Entry<String, BlockState> s : materials.entrySet()) {
                IMultiStateCopycatBlockEntity multiStateBE;
                Vec3i inner = multiStateBlock.getVectorFromProperty(state, s.getKey());
                BlockEntity blockEntity = world.getBlockEntity(pos);
                boolean enableCT = !(blockEntity instanceof IMultiStateCopycatBlockEntity) || (multiStateBE = (IMultiStateCopycatBlockEntity)blockEntity).getMaterialItemStorage().getMaterialItem(s.getKey()).enableCT();
                ScaledBlockAndTintGetterForge scaledWorld = new ScaledBlockAndTintGetterForge(s.getKey(), world, pos, inner, multiStateBlock.vectorScale(state), p -> true);
                OcclusionData occlusionData = new OcclusionData();
                if (!VirtualRenderHelper.isVirtual((ModelData)blockEntityData)) {
                    this.gatherOcclusionData(scaledWorld, pos, state, s.getValue(), occlusionData, copycatBlock);
                }
                occlusionMap.put(s.getKey(), occlusionData);
                ScaledBlockAndTintGetterForge filteredWorld = new ScaledBlockAndTintGetterForge(s.getKey(), world, pos, inner, multiStateBlock.vectorScale(state), targetPos -> {
                    if (!enableCT) {
                        return false;
                    }
                    return multiStateBlock.canConnectTexturesToward((String)s.getKey(), scaledWorld, pos, (BlockPos)targetPos, state);
                });
                wrappedDataMap.put(s.getKey(), CopycatModelCore.getModelOf(s.getValue()).getModelData((BlockAndTintGetter)filteredWorld, pos, s.getValue(), ModelData.EMPTY));
            }
            return builder.with(OCCLUSION_PROPERTY, occlusionMap).with(WRAPPED_DATA_PROPERTY, wrappedDataMap);
        }
        BlockState material2 = materials.get("material");
        if (material2 == null) {
            return builder;
        }
        OcclusionData occlusionData = new OcclusionData();
        if (!VirtualRenderHelper.isVirtual((ModelData)blockEntityData)) {
            this.gatherOcclusionData(world, pos, state, material2, occlusionData, copycatBlock);
        }
        Map<String, OcclusionData> occlusionMap = Map.of("material", occlusionData);
        builder.with(OCCLUSION_PROPERTY, occlusionMap);
        FilteredBlockAndTintGetterForge filteredWorld = new FilteredBlockAndTintGetterForge(world, targetPos -> {
            ICopycatBlockEntity copycatBE;
            BlockEntity be = world.getBlockEntity(pos);
            if (be instanceof ICopycatBlockEntity && !(copycatBE = (ICopycatBlockEntity)be).isCTEnabled()) {
                return false;
            }
            return copycatBlock.canConnectTexturesToward(world, pos, (BlockPos)targetPos, state);
        });
        Map<String, ModelData> wrappedDataMap = Map.of("material", CopycatModelCore.getModelOf(material2).getModelData((BlockAndTintGetter)filteredWorld, pos, material2, ModelData.EMPTY));
        return builder.with(WRAPPED_DATA_PROPERTY, wrappedDataMap);
    }

    private void gatherOcclusionData(BlockAndTintGetter world, BlockPos pos, BlockState state, BlockState material, OcclusionData occlusionData, ICopycatBlock copycatBlock) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction face : Iterate.directions) {
            BlockPos.MutableBlockPos neighbourPos = mutablePos.setWithOffset((Vec3i)pos, face);
            BlockState neighbourState = world.getBlockState((BlockPos)neighbourPos);
            if (state.supportsExternalFaceHiding() && neighbourState.hidesNeighborFace((BlockGetter)world, (BlockPos)neighbourPos, material, face.getOpposite())) {
                occlusionData.occlude(face);
                continue;
            }
            if (Block.shouldRenderFace((BlockState)state, (BlockGetter)world, (BlockPos)pos, (Direction)face, (BlockPos)neighbourPos)) continue;
            occlusionData.occlude(face);
        }
    }

    @NotNull
    protected List<CopycatRenderContextNeoForge.CopycatBakedQuad> getQuads(BlockState state, @NotNull RandomSource rand, @NotNull ModelData data, RenderType renderType) {
        this.prepareModelCore(state, rand, data);
        ArrayList<CopycatRenderContextNeoForge.CopycatBakedQuad> allQuads = new ArrayList<CopycatRenderContextNeoForge.CopycatBakedQuad>();
        Map<String, BlockState> materials = CopycatModelNeoForge.getMaterials(data);
        Map<String, OcclusionData> occlusionDataMap = CopycatModelNeoForge.getOcclusion(data);
        Map<String, ModelData> wrappedDataMap = CopycatModelNeoForge.getWrappedData(data);
        boolean isVirtual = VirtualRenderHelper.isVirtual((ModelData)data);
        for (CopycatModelCore.ModelEntry entry : this.entries) {
            BakedModel model;
            BlockState material = entry.materialMapper().map(state, materials.get(entry.key()));
            if (entry.type().onlyWhenVirtual() && !isVirtual) continue;
            if (entry.type().useCopycatLogic() && material == null) {
                if (!materials.isEmpty() || !isVirtual) continue;
                material = AllBlocks.COPYCAT_BASE.getDefaultState();
            }
            if ((model = this.getModelForEntry(entry, state, material)) == null) continue;
            BlockState wrappedState = state;
            ModelData wrappedData = data;
            if (entry.type().useCopycatLogic()) {
                wrappedState = material;
                wrappedData = wrappedDataMap.get(entry.key());
                if (wrappedData == null) {
                    wrappedData = ModelData.EMPTY;
                }
            }
            if (renderType != null && !model.getRenderTypes(wrappedState, rand, wrappedData).contains(renderType)) continue;
            if (VirtualRenderHelper.isVirtual((ModelData)wrappedData) != isVirtual) {
                wrappedData = ModelDataUtils.mergeData(wrappedData, VirtualRenderHelper.VIRTUAL_DATA).build();
            }
            ArrayList<CopycatRenderContextNeoForge.CopycatBakedQuad> quads = new ArrayList<CopycatRenderContextNeoForge.CopycatBakedQuad>();
            for (Direction side : Iterate.directions) {
                List templateQuads = model.getQuads(wrappedState, side, rand, wrappedData, renderType);
                for (BakedQuad templateQuad : templateQuads) {
                    quads.add(new CopycatRenderContextNeoForge.CopycatBakedQuad(templateQuad, side, entry.key()));
                }
            }
            List templateQuads = model.getQuads(wrappedState, null, rand, wrappedData, renderType);
            for (BakedQuad templateQuad : templateQuads) {
                quads.add(new CopycatRenderContextNeoForge.CopycatBakedQuad(templateQuad, null, entry.key()));
            }
            List<CopycatRenderContextNeoForge.CopycatBakedQuad> croppedQuads = this.getCroppedQuads(entry, state, quads, material);
            OcclusionData occlusionData = occlusionDataMap.get(entry.key());
            for (CopycatRenderContextNeoForge.CopycatBakedQuad croppedQuad : croppedQuads) {
                if (occlusionData != null && occlusionData.isOccluded(croppedQuad.cullFace)) continue;
                if (entry.type().useCopycatLogic()) {
                    croppedQuad.cullFace = null;
                }
                allQuads.add(croppedQuad);
            }
        }
        return allQuads;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction direction, @NotNull RandomSource random) {
        return this.getQuads(state, direction, random, ModelData.EMPTY, null);
    }

    @NotNull
    public List<BakedQuad> getQuads(BlockState state, Direction side, @NotNull RandomSource rand, @NotNull ModelData data, RenderType renderType) {
        List<CopycatRenderContextNeoForge.CopycatBakedQuad> templateQuads = this.renderSession.get().getQuads(state, rand, data, renderType);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (CopycatRenderContextNeoForge.CopycatBakedQuad quad : templateQuads) {
            if (side != quad.cullFace) continue;
            quads.add(quad.toBakedQuad());
        }
        return quads;
    }

    private List<CopycatRenderContextNeoForge.CopycatBakedQuad> getCroppedQuads(CopycatModelCore.ModelEntry entry, BlockState state, List<CopycatRenderContextNeoForge.CopycatBakedQuad> templateQuads, BlockState material) {
        if (entry.part() == null) {
            return templateQuads;
        }
        ArrayList<CopycatRenderContextNeoForge.CopycatBakedQuad> quads = new ArrayList<CopycatRenderContextNeoForge.CopycatBakedQuad>();
        CopycatRenderContextNeoForge context = new CopycatRenderContextNeoForge(templateQuads, (List<CopycatRenderContextNeoForge.CopycatBakedQuad>)quads, entry.key());
        entry.part().emitCopycatQuads(entry.key(), state, context, material);
        return quads;
    }

    public BakedModel getModelForEntry(CopycatModelCore.ModelEntry entry, BlockState state, BlockState material) {
        Block block;
        if (entry.model() == null) {
            return this.originalModel;
        }
        if (this.core.colorize && (block = state.getBlock()) instanceof IMultiStateCopycatBlock) {
            IMultiStateCopycatBlock multiState = (IMultiStateCopycatBlock)block;
            if (AllBlocks.COPYCAT_BASE.has(material)) {
                material = (BlockState)CCBlocks.COPYCAT_BASE.getDefaultState().setValue((Property)CCBlockStateProperties.BASE_TYPE, (Comparable)Integer.valueOf(multiState.getColorIndex(entry.key()) % 3));
            }
        }
        return entry.model().getModel(state, material);
    }

    protected void prepareModelCore(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        this.core.prepareForRender();
    }

    @NotNull
    public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
        @NotNull Map<String, BlockState> material = CopycatModelNeoForge.getMaterials(data);
        if (material.isEmpty()) {
            return super.getParticleIcon(data);
        }
        Map.Entry<String, BlockState> key = material.entrySet().stream().filter(s -> !((BlockState)s.getValue()).is((Block)AllBlocks.COPYCAT_BASE.get())).findFirst().orElse(material.entrySet().iterator().next());
        return CopycatModelCore.getModelOf(key.getValue()).getParticleIcon(CopycatModelNeoForge.getWrappedData(data).get(key.getKey()));
    }

    @NotNull
    public static BlockState getMaterial(ModelData data) {
        BlockState material = data == null ? null : (BlockState)data.get(MATERIAL_PROPERTY);
        return material == null ? AllBlocks.COPYCAT_BASE.getDefaultState() : material;
    }

    @NotNull
    public static Map<String, BlockState> getMaterials(ModelData data) {
        Map materials = data == null ? null : (Map)data.get(MATERIALS_PROPERTY);
        return materials == null ? Map.of() : materials;
    }

    @NotNull
    public static Map<String, OcclusionData> getOcclusion(ModelData data) {
        Map occlusions = data == null ? null : (Map)data.get(OCCLUSION_PROPERTY);
        return occlusions == null ? Map.of() : occlusions;
    }

    @NotNull
    public static Map<String, ModelData> getWrappedData(ModelData data) {
        Map wrappedData = data == null ? null : (Map)data.get(WRAPPED_DATA_PROPERTY);
        return wrappedData == null ? Map.of() : wrappedData;
    }

    public static class OcclusionData {
        private final boolean[] occluded = new boolean[6];

        public void occlude(Direction face) {
            this.occluded[face.get3DDataValue()] = true;
        }

        public boolean isOccluded(Direction face) {
            return face != null && this.occluded[face.get3DDataValue()];
        }
    }

    public static class RenderSession
    implements Renderer {
        private final Renderer renderer;
        private BlockState state = null;
        private RandomSource rand = null;
        private ModelData data = null;
        private RenderType renderType = null;
        private List<CopycatRenderContextNeoForge.CopycatBakedQuad> result = null;

        public RenderSession(Renderer renderer) {
            this.renderer = renderer;
        }

        @Override
        public List<CopycatRenderContextNeoForge.CopycatBakedQuad> getQuads(BlockState state, @NotNull RandomSource rand, @NotNull ModelData data, RenderType renderType) {
            if (Objects.equals(this.state, state) && this.rand == rand && this.data == data && this.renderType == renderType && this.result != null) {
                return this.result;
            }
            this.state = state;
            this.rand = rand;
            this.data = data;
            this.renderType = renderType;
            this.result = this.renderer.getQuads(state, rand, data, renderType);
            return this.result;
        }
    }

    @FunctionalInterface
    public static interface Renderer {
        public List<CopycatRenderContextNeoForge.CopycatBakedQuad> getQuads(BlockState var1, @NotNull RandomSource var2, @NotNull ModelData var3, RenderType var4);
    }
}

