/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util.packet;

import com.railwayteam.railways.mixin_interfaces.ILimited;
import com.railwayteam.railways.multiloader.C2SPacket;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.graph.TrackGraphLocation;
import com.simibubi.create.content.trains.signal.TrackEdgePoint;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;

public class StationLimitPacket
implements C2SPacket {
    private final BlockPos pos;
    private final boolean limitEnabled;

    public StationLimitPacket(BlockPos pos, boolean limitEnabled) {
        this.pos = pos;
        this.limitEnabled = limitEnabled;
    }

    public StationLimitPacket(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.limitEnabled = buf.readBoolean();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeBoolean(this.limitEnabled);
    }

    @Override
    public void handle(ServerPlayer sender) {
        if (sender.level().isClientSide()) {
            return;
        }
        BlockEntity be = sender.level().getBlockEntity(this.pos);
        if (!(be instanceof StationBlockEntity)) {
            return;
        }
        StationBlockEntity stationBE = (StationBlockEntity)be;
        GlobalStation station = stationBE.getStation();
        TrackGraphLocation graphLocation = stationBE.edgePoint.determineGraphLocation();
        if (station != null && graphLocation != null) {
            ((ILimited)station).setLimitEnabled(this.limitEnabled);
            Create.RAILWAYS.sync.pointAdded(graphLocation.graph, (TrackEdgePoint)station);
            Create.RAILWAYS.markTracksDirty();
        }
    }
}

