/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util.packet;

import com.railwayteam.railways.multiloader.S2CPacket;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.trains.entity.Train;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class SplitTrainEndPacket
implements S2CPacket {
    final UUID newTrainId;
    final UUID originalTrainOwner;
    final double speed;
    final boolean doubleEnded;

    public SplitTrainEndPacket(UUID newTrainId, UUID originalTrainOwner, double speed, boolean doubleEnded) {
        this.newTrainId = newTrainId;
        this.originalTrainOwner = originalTrainOwner;
        this.speed = speed;
        this.doubleEnded = doubleEnded;
    }

    public SplitTrainEndPacket(FriendlyByteBuf buf) {
        this.newTrainId = buf.readUUID();
        this.originalTrainOwner = buf.readUUID();
        this.speed = buf.readDouble();
        this.doubleEnded = buf.readBoolean();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.newTrainId);
        buffer.writeUUID(this.originalTrainOwner);
        buffer.writeDouble(this.speed);
        buffer.writeBoolean(this.doubleEnded);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(Minecraft mc) {
        ClientLevel level = mc.level;
        if (level != null) {
            Train train = (Train)CreateClient.RAILWAYS.trains.get(this.newTrainId);
            if (train == null) {
                return;
            }
            train.doubleEnded = this.doubleEnded;
            train.speed = this.speed;
        }
    }
}

