/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util.packet;

import com.railwayteam.railways.content.distant_signals.IOverridableSignal;
import com.railwayteam.railways.multiloader.S2CPacket;
import com.simibubi.create.content.trains.signal.SignalBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class OverridableSignalPacket
implements S2CPacket {
    final BlockPos blockPos;
    @Nullable
    final BlockPos signalPos;
    final SignalBlockEntity.SignalState signalState;
    final int ticks;
    final boolean distantSignal;

    public OverridableSignalPacket(BlockPos displayPos, @Nullable BlockPos signalPos, SignalBlockEntity.SignalState signalState, int ticks, boolean distantSignal) {
        this.blockPos = displayPos;
        this.signalPos = signalPos;
        this.signalState = signalState;
        this.ticks = ticks;
        this.distantSignal = distantSignal;
    }

    public OverridableSignalPacket(FriendlyByteBuf buf) {
        this.blockPos = buf.readBlockPos();
        this.signalPos = buf.readBoolean() ? buf.readBlockPos() : null;
        this.signalState = SignalBlockEntity.SignalState.values()[buf.readInt()];
        this.ticks = buf.readInt();
        this.distantSignal = buf.readBoolean();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.blockPos);
        buffer.writeBoolean(this.signalPos != null);
        if (this.signalPos != null) {
            buffer.writeBlockPos(this.signalPos);
        }
        buffer.writeInt(this.signalState.ordinal());
        buffer.writeInt(this.ticks);
        buffer.writeBoolean(this.distantSignal);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(Minecraft mc) {
        BlockEntity te;
        ClientLevel level = mc.level;
        if (level != null && (te = level.getBlockEntity(this.blockPos)) instanceof IOverridableSignal) {
            BlockEntity blockEntity;
            IOverridableSignal overridableSignal = (IOverridableSignal)te;
            SignalBlockEntity signalBE = null;
            if (this.signalPos != null && (blockEntity = level.getBlockEntity(this.signalPos)) instanceof SignalBlockEntity) {
                SignalBlockEntity signal;
                signalBE = signal = (SignalBlockEntity)blockEntity;
            }
            overridableSignal.railways$refresh(signalBE, this.signalState, this.ticks, this.distantSignal);
        }
    }
}

