/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util.packet;

import com.railwayteam.railways.mixin.AccessorTrain;
import com.railwayteam.railways.multiloader.S2CPacket;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.trains.entity.Train;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class InitializeTrainCarriagesPacket
implements S2CPacket {
    final UUID trainId;
    final int numberOfCarriages;
    final List<Integer> carriageSpacing;

    public InitializeTrainCarriagesPacket(Train train) {
        this.trainId = train.id;
        this.numberOfCarriages = train.carriages.size();
        this.carriageSpacing = new ArrayList<Integer>(train.carriageSpacing);
    }

    public InitializeTrainCarriagesPacket(FriendlyByteBuf buf) {
        this.trainId = buf.readUUID();
        this.numberOfCarriages = buf.readInt();
        int spacingSize = buf.readInt();
        this.carriageSpacing = new ArrayList<Integer>();
        for (int i = 0; i < spacingSize; ++i) {
            this.carriageSpacing.add(buf.readInt());
        }
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.trainId);
        buffer.writeInt(this.numberOfCarriages);
        buffer.writeInt(this.carriageSpacing.size());
        for (int spacing : this.carriageSpacing) {
            buffer.writeInt(spacing);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(Minecraft mc) {
        Train train;
        ClientLevel level = mc.level;
        if (level != null && (train = (Train)CreateClient.RAILWAYS.trains.get(this.trainId)) != null) {
            train.carriageSpacing.clear();
            train.carriageSpacing.addAll(this.carriageSpacing);
            double[] stressArray = new double[this.numberOfCarriages];
            for (int i = 0; i < this.numberOfCarriages; ++i) {
                stressArray[i] = 0.0;
            }
            ((AccessorTrain)train).railways$setStress(stressArray);
        }
    }
}

