/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util.packet;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.multiloader.C2SPacket;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.entity.Train;
import java.lang.reflect.Method;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class HonkTrainPacket
implements C2SPacket {
    final UUID trainId;
    final boolean isHonk;

    public HonkTrainPacket(UUID trainId, boolean isHonk) {
        this.trainId = trainId;
        this.isHonk = isHonk;
    }

    public HonkTrainPacket(FriendlyByteBuf buf) {
        this.trainId = buf.readUUID();
        this.isHonk = buf.readBoolean();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.trainId);
        buffer.writeBoolean(this.isHonk);
    }

    @Override
    public void handle(ServerPlayer sender) {
        block20: {
            Train train = (Train)Create.RAILWAYS.trains.get(this.trainId);
            if (train == null) {
                return;
            }
            try {
                String[] candidates = new String[]{"honk", "playHonk", "setHonk", "setHornState"};
                boolean invoked = false;
                for (String name : candidates) {
                    try {
                        Method m = Train.class.getMethod(name, Boolean.TYPE);
                        m.invoke((Object)train, this.isHonk);
                        invoked = true;
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                }
                if (invoked) break block20;
                try {
                    Method determine = null;
                    try {
                        determine = Train.class.getMethod("determineHonk", Level.class);
                    }
                    catch (NoSuchMethodException e1) {
                        try {
                            determine = Train.class.getMethod("determineHonk", ServerLevel.class);
                        }
                        catch (NoSuchMethodException e2) {
                            determine = null;
                        }
                    }
                    if (determine != null) {
                        if (this.isHonk) {
                            determine.invoke((Object)train, sender.serverLevel());
                        } else {
                            try {
                                Method stop = Train.class.getMethod("stopHonk", new Class[0]);
                                stop.invoke((Object)train, new Object[0]);
                            }
                            catch (NoSuchMethodException stop) {}
                        }
                        break block20;
                    }
                    try {
                        Method determineNoArgs = Train.class.getMethod("determineHonk", new Class[0]);
                        if (this.isHonk) {
                            determineNoArgs.invoke((Object)train, new Object[0]);
                        }
                    }
                    catch (NoSuchMethodException ignored) {
                        Railways.LOGGER.warn("HonkTrainPacket: unable to find a suitable method to trigger train honk for train {}", (Object)this.trainId);
                    }
                }
                catch (ReflectiveOperationException e) {
                    Railways.LOGGER.warn("HonkTrainPacket: reflection error when triggering train honk for train {}: {}", (Object)this.trainId, (Object)e.toString());
                }
            }
            catch (ReflectiveOperationException e) {
                Railways.LOGGER.warn("HonkTrainPacket: reflection error when triggering train honk for train {}: {}", (Object)this.trainId, (Object)e.toString());
            }
        }
    }
}

