/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util.packet;

import com.railwayteam.railways.content.handcar.HandcarItem;
import com.railwayteam.railways.multiloader.C2SPacket;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.trains.graph.TrackGraphLocation;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.BezierTrackPointLocation;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackTargetingBlockItem;
import com.simibubi.create.foundation.utility.CreateLang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.mutable.MutableObject;

public class CurvedTrackHandcarPlacementPacket
implements C2SPacket {
    private final BlockPos pos;
    private final BlockPos targetPos;
    private final boolean front;
    private final int segment;
    private final int slot;

    public CurvedTrackHandcarPlacementPacket(BlockPos pos, BlockPos targetPos, int segment, boolean front, int slot) {
        this.pos = pos;
        this.targetPos = targetPos;
        this.segment = segment;
        this.front = front;
        this.slot = slot;
    }

    public CurvedTrackHandcarPlacementPacket(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.targetPos = buf.readBlockPos();
        this.segment = buf.readVarInt();
        this.front = buf.readBoolean();
        this.slot = buf.readVarInt();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeBlockPos(this.targetPos);
        buffer.writeVarInt(this.segment);
        buffer.writeBoolean(this.front);
        buffer.writeVarInt(this.slot);
    }

    protected void actuallyHandle(ServerPlayer player, TrackBlockEntity be) {
        boolean success;
        BezierTrackPointLocation targetLocation = new BezierTrackPointLocation(this.targetPos, this.segment);
        BezierConnection bc = (BezierConnection)be.getConnections().get(this.targetPos);
        if (bc == null) {
            return;
        }
        TrackMaterial.TrackType trackType = bc.getMaterial().trackType;
        if (trackType != TrackMaterial.TrackType.STANDARD && trackType != CRTrackMaterials.CRTrackType.UNIVERSAL) {
            return;
        }
        ItemStack stack = player.getInventory().getItem(this.slot);
        Item item = stack.getItem();
        if (!(item instanceof HandcarItem)) {
            return;
        }
        HandcarItem handcarItem = (HandcarItem)item;
        MutableObject result = new MutableObject(null);
        MutableObject resultLoc = new MutableObject(null);
        HandcarItem.withGraphLocation(player.level(), this.pos, this.front, targetLocation, (overlap, location) -> {
            result.setValue(overlap);
            resultLoc.setValue(location);
        });
        if (result.getValue() != TrackTargetingBlockItem.OverlapResult.VALID || resultLoc.getValue() == null) {
            if (result.getValue() != null && ((TrackTargetingBlockItem.OverlapResult)result.getValue()).feedback != null) {
                player.displayClientMessage((Component)CreateLang.translateDirect((String)((TrackTargetingBlockItem.OverlapResult)result.getValue()).feedback, (Object[])new Object[0]).withStyle(ChatFormatting.RED), true);
                AllSoundEvents.DENY.play(player.level(), null, (Vec3i)this.pos, 0.5f, 1.0f);
            }
            return;
        }
        TrackGraphLocation loc = (TrackGraphLocation)resultLoc.getValue();
        Direction assemblyDirection = Direction.fromYRot((double)player.getYRot());
        if (!this.front) {
            assemblyDirection = assemblyDirection.getOpposite();
        }
        if (success = handcarItem.placeHandcar(loc, player.level(), (Player)player, this.pos, assemblyDirection)) {
            stack.shrink(1);
        }
    }

    @Override
    public void handle(ServerPlayer sender) {
        Level world = sender.level();
        if (world == null || !world.isLoaded(this.pos)) {
            return;
        }
        if (!this.pos.closerThan((Vec3i)sender.blockPosition(), 64.0)) {
            return;
        }
        BlockEntity blockEntity = world.getBlockEntity(this.pos);
        if (blockEntity instanceof TrackBlockEntity) {
            TrackBlockEntity tbe = (TrackBlockEntity)blockEntity;
            this.actuallyHandle(sender, tbe);
        }
    }
}

