/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util.neoforge;

import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.neoforge.ConductorFakePlayerForge;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class EntityUtilsImpl {
    public static CompoundTag getPersistentData(Entity entity) {
        return entity.getPersistentData();
    }

    public static void givePlayerItem(Player player, ItemStack stack) {
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
    }

    public static ServerPlayer createConductorFakePlayer(ServerLevel level, ConductorEntity conductor) {
        return new ConductorFakePlayerForge(level, conductor);
    }

    public static double getReachDistance(Player player) {
        return player.blockInteractionRange();
    }

    public static boolean handleUseEvent(Player player, InteractionHand hand, BlockHitResult hit) {
        PlayerInteractEvent.RightClickBlock event = CommonHooks.onRightClickBlock((Player)player, (InteractionHand)InteractionHand.MAIN_HAND, (BlockPos)hit.getBlockPos(), (BlockHitResult)hit);
        return event.getUseBlock() != TriState.FALSE || event.getUseItem() != TriState.FALSE;
    }
}

