/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.registry;

import com.google.common.collect.ImmutableSet;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.custom_tracks.NoCollisionCustomTrackBlock;
import com.railwayteam.railways.content.custom_tracks.monorail.MonorailTrackBlock;
import com.railwayteam.railways.content.custom_tracks.narrow_gauge.NarrowGaugeTrackBlock;
import com.railwayteam.railways.content.custom_tracks.phantom.PhantomTrackBlock;
import com.railwayteam.railways.content.custom_tracks.wide_gauge.WideGaugeTrackBlock;
import com.railwayteam.railways.mixin.AccessorBlockEntityType;
import com.railwayteam.railways.registry.CRBlocks;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackMaterialFactory;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.Nullable;

public class CRTrackMaterials {
    public static final TrackMaterial ACACIA = TrackMaterialFactory.make((ResourceLocation)Railways.asResource("acacia")).lang("Acacia").block(() -> CRBlocks.ACACIA_TRACK).particle(ResourceLocation.withDefaultNamespace((String)"block/acacia_planks")).sleeper(new ItemLike[]{Blocks.ACACIA_SLAB}).standardModels().build();
    public static final TrackMaterial BIRCH = TrackMaterialFactory.make((ResourceLocation)Railways.asResource("birch")).lang("Birch").block(() -> CRBlocks.BIRCH_TRACK).particle(ResourceLocation.withDefaultNamespace((String)"block/birch_planks")).sleeper(new ItemLike[]{Blocks.BIRCH_SLAB}).standardModels().build();
    public static final TrackMaterial CRIMSON = TrackMaterialFactory.make((ResourceLocation)Railways.asResource("crimson")).lang("Crimson").block(() -> CRBlocks.CRIMSON_TRACK).particle(ResourceLocation.withDefaultNamespace((String)"block/crimson_planks")).sleeper(new ItemLike[]{Blocks.CRIMSON_SLAB}).rails(new ItemLike[]{Items.GOLD_NUGGET}).standardModels().build();
    public static final TrackMaterial DARK_OAK = TrackMaterialFactory.make((ResourceLocation)Railways.asResource("dark_oak")).lang("Dark Oak").block(() -> CRBlocks.DARK_OAK_TRACK).particle(ResourceLocation.withDefaultNamespace((String)"block/dark_oak_planks")).sleeper(new ItemLike[]{Blocks.DARK_OAK_SLAB}).standardModels().build();
    public static final TrackMaterial JUNGLE = TrackMaterialFactory.make((ResourceLocation)Railways.asResource("jungle")).lang("Jungle").block(() -> CRBlocks.JUNGLE_TRACK).particle(ResourceLocation.withDefaultNamespace((String)"block/jungle_planks")).sleeper(new ItemLike[]{Blocks.JUNGLE_SLAB}).standardModels().build();
    public static final TrackMaterial OAK = TrackMaterialFactory.make((ResourceLocation)Railways.asResource("oak")).lang("Oak").block(() -> CRBlocks.OAK_TRACK).particle(ResourceLocation.withDefaultNamespace((String)"block/oak_planks")).sleeper(new ItemLike[]{Blocks.OAK_SLAB}).standardModels().build();
    public static final TrackMaterial SPRUCE = TrackMaterialFactory.make((ResourceLocation)Railways.asResource("spruce")).lang("Spruce").block(() -> CRBlocks.SPRUCE_TRACK).particle(ResourceLocation.withDefaultNamespace((String)"block/spruce_planks")).sleeper(new ItemLike[]{Blocks.SPRUCE_SLAB}).standardModels().build();
    public static final TrackMaterial WARPED = TrackMaterialFactory.make((ResourceLocation)Railways.asResource("warped")).lang("Warped").block(() -> CRBlocks.WARPED_TRACK).particle(ResourceLocation.withDefaultNamespace((String)"block/warped_planks")).sleeper(new ItemLike[]{Blocks.WARPED_SLAB}).rails(new ItemLike[]{Items.GOLD_NUGGET}).standardModels().build();
    public static final TrackMaterial BLACKSTONE = TrackMaterialFactory.make((ResourceLocation)Railways.asResource("blackstone")).lang("Blackstone").block(() -> CRBlocks.BLACKSTONE_TRACK).particle(ResourceLocation.withDefaultNamespace((String)"block/blackstone")).sleeper(new ItemLike[]{Blocks.BLACKSTONE_SLAB}).rails(new ItemLike[]{Items.GOLD_NUGGET}).standardModels().build();
    public static final TrackMaterial MANGROVE = TrackMaterialFactory.make((ResourceLocation)Railways.asResource("mangrove")).lang("Mangrove").block(() -> CRBlocks.MANGROVE_TRACK).particle(ResourceLocation.withDefaultNamespace((String)"block/mangrove_planks")).sleeper(new ItemLike[]{Blocks.MANGROVE_SLAB}).standardModels().build();
    public static final TrackMaterial CHERRY = TrackMaterialFactory.make((ResourceLocation)Railways.asResource("cherry")).lang("Cherry").block(() -> CRBlocks.CHERRY_TRACK).particle(ResourceLocation.withDefaultNamespace((String)"block/cherry_planks")).sleeper(new ItemLike[]{Blocks.CHERRY_SLAB}).standardModels().build();
    public static final TrackMaterial BAMBOO = TrackMaterialFactory.make((ResourceLocation)Railways.asResource("bamboo")).lang("Bamboo").block(() -> CRBlocks.BAMBOO_TRACK).particle(ResourceLocation.withDefaultNamespace((String)"block/bamboo_block")).sleeper(new ItemLike[]{Items.BAMBOO}).standardModels().build();
    public static final TrackMaterial STRIPPED_BAMBOO = TrackMaterialFactory.make((ResourceLocation)Railways.asResource("stripped_bamboo")).lang("Stripped Bamboo").block(() -> CRBlocks.STRIPPED_BAMBOO_TRACK).particle(ResourceLocation.withDefaultNamespace((String)"block/bamboo_planks")).sleeper(new ItemLike[]{Blocks.BAMBOO_SLAB}).standardModels().build();
    public static final TrackMaterial MONORAIL = TrackMaterialFactory.make((ResourceLocation)Railways.asResource("monorail")).lang("Monorail").block(() -> CRBlocks.MONORAIL_TRACK).particle(Railways.asResource("block/monorail/monorail")).trackType(CRTrackType.MONORAIL).noRecipeGen().customModels(() -> () -> PartialModel.of((ResourceLocation)Railways.asResource("block/monorail/monorail/monorail_half")), () -> () -> PartialModel.of((ResourceLocation)Railways.asResource("block/empty")), () -> () -> PartialModel.of((ResourceLocation)Railways.asResource("block/empty"))).build();
    public static final TrackMaterial ENDER = TrackMaterialFactory.make((ResourceLocation)Railways.asResource("ender")).lang("Ender").block(() -> CRBlocks.ENDER_TRACK).particle(ResourceLocation.withDefaultNamespace((String)"block/end_stone")).sleeper(new ItemLike[]{Blocks.END_STONE_BRICK_SLAB}).standardModels().build();
    public static final TrackMaterial TIELESS = TrackMaterialFactory.make((ResourceLocation)Railways.asResource("tieless")).lang("Tieless").block(() -> CRBlocks.TIELESS_TRACK).particle(ResourceLocation.withDefaultNamespace((String)"block/glass")).sleeper(new ItemLike[]{Blocks.GLASS_PANE}).customBlockFactory(NoCollisionCustomTrackBlock::new).standardModels().build();
    public static final TrackMaterial PHANTOM = TrackMaterialFactory.make((ResourceLocation)Railways.asResource("phantom")).lang("Phantom").block(() -> CRBlocks.PHANTOM_TRACK).particle(ResourceLocation.withDefaultNamespace((String)"block/glass")).noRecipeGen().trackType(CRTrackType.UNIVERSAL).customBlockFactory(PhantomTrackBlock::new).standardModels().build();
    public static final TrackMaterial WIDE_GAUGE_ANDESITE = CRTrackMaterials.wideVariant(TrackMaterial.ANDESITE);
    public static final TrackMaterial NARROW_GAUGE_ANDESITE = CRTrackMaterials.narrowVariant(TrackMaterial.ANDESITE);
    public static final Map<TrackMaterial, TrackMaterial> WIDE_GAUGE = new HashMap<TrackMaterial, TrackMaterial>();
    public static final Map<TrackMaterial, TrackMaterial> WIDE_GAUGE_REVERSE = new HashMap<TrackMaterial, TrackMaterial>();
    public static final Map<TrackMaterial, TrackMaterial> NARROW_GAUGE = new HashMap<TrackMaterial, TrackMaterial>();
    public static final Map<TrackMaterial, TrackMaterial> NARROW_GAUGE_REVERSE = new HashMap<TrackMaterial, TrackMaterial>();

    public static TrackMaterial getWide(TrackMaterial material) {
        return WIDE_GAUGE.get(material);
    }

    @Nullable
    public static TrackMaterial getBaseFromWide(TrackMaterial material) {
        if (!WIDE_GAUGE_REVERSE.containsKey(material)) {
            return null;
        }
        return WIDE_GAUGE_REVERSE.get(material);
    }

    private static TrackMaterial wideVariant(TrackMaterial material) {
        Object path = "";
        if (!material.id.getNamespace().equals("railways")) {
            path = material.id.getNamespace() + "_";
        }
        path = (String)path + material.id.getPath() + "_wide";
        return TrackMaterialFactory.make((ResourceLocation)Railways.asResource((String)path)).lang("Wide " + material.langName).trackType(CRTrackType.WIDE_GAUGE).block(() -> CRBlocks.WIDE_GAUGE_TRACKS.get(WIDE_GAUGE.get(material))).particle(material.particle).noRecipeGen().standardModels().build();
    }

    public static TrackMaterial getNarrow(TrackMaterial material) {
        return NARROW_GAUGE.get(material);
    }

    @Nullable
    public static TrackMaterial getBaseFromNarrow(TrackMaterial material) {
        if (!NARROW_GAUGE_REVERSE.containsKey(material)) {
            return null;
        }
        return NARROW_GAUGE_REVERSE.get(material);
    }

    private static TrackMaterial narrowVariant(TrackMaterial material) {
        Object path = "";
        if (!material.id.getNamespace().equals("railways")) {
            path = material.id.getNamespace() + "_";
        }
        path = (String)path + material.id.getPath() + "_narrow";
        return TrackMaterialFactory.make((ResourceLocation)Railways.asResource((String)path)).lang("Narrow " + material.langName).trackType(CRTrackType.NARROW_GAUGE).block(() -> CRBlocks.NARROW_GAUGE_TRACKS.get(NARROW_GAUGE.get(material))).particle(material.particle).noRecipeGen().standardModels().build();
    }

    public static void register() {
    }

    public static void addToBlockEntityType(TrackBlock block) {
        BlockEntityType type;
        try {
            type = block.getBlockEntityType();
        }
        catch (NullPointerException ignored) {
            return;
        }
        ImmutableSet validBlocks = ((AccessorBlockEntityType)type).getValidBlocks();
        validBlocks = new ImmutableSet.Builder().add((Object[])((Block[])validBlocks.toArray(Block[]::new))).add((Object)block).build();
        ((AccessorBlockEntityType)type).setValidBlocks((Set<Block>)validBlocks);
    }

    static {
        WIDE_GAUGE.put(TrackMaterial.ANDESITE, WIDE_GAUGE_ANDESITE);
        WIDE_GAUGE_REVERSE.put(WIDE_GAUGE_ANDESITE, TrackMaterial.ANDESITE);
        for (TrackMaterial baseMaterial : TrackMaterial.allFromMod((String)"railways")) {
            if (baseMaterial.trackType != TrackMaterial.TrackType.STANDARD) continue;
            TrackMaterial wideMaterial = CRTrackMaterials.wideVariant(baseMaterial);
            WIDE_GAUGE.put(baseMaterial, wideMaterial);
            WIDE_GAUGE_REVERSE.put(wideMaterial, baseMaterial);
        }
        NARROW_GAUGE.put(TrackMaterial.ANDESITE, NARROW_GAUGE_ANDESITE);
        NARROW_GAUGE_REVERSE.put(NARROW_GAUGE_ANDESITE, TrackMaterial.ANDESITE);
        for (TrackMaterial baseMaterial : TrackMaterial.allFromMod((String)"railways")) {
            if (baseMaterial.trackType != TrackMaterial.TrackType.STANDARD) continue;
            TrackMaterial narrowMaterial = CRTrackMaterials.narrowVariant(baseMaterial);
            NARROW_GAUGE.put(baseMaterial, narrowMaterial);
            NARROW_GAUGE_REVERSE.put(narrowMaterial, baseMaterial);
        }
    }

    public static class CRTrackType
    extends TrackMaterial.TrackType {
        public static final TrackMaterial.TrackType MONORAIL = new CRTrackType(Railways.asResource("monorail"), MonorailTrackBlock::new);
        public static final TrackMaterial.TrackType WIDE_GAUGE = new CRTrackType(Railways.asResource("wide_gauge"), WideGaugeTrackBlock::new);
        public static final TrackMaterial.TrackType NARROW_GAUGE = new CRTrackType(Railways.asResource("narrow_gauge"), NarrowGaugeTrackBlock::new);
        public static final TrackMaterial.TrackType UNIVERSAL = new CRTrackType(Railways.asResource("universal"), TrackBlock::new);

        public CRTrackType(ResourceLocation id, TrackMaterial.TrackType.TrackBlockFactory factory) {
            super(id, factory);
        }
    }
}

