/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.registry;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.buffer.BlockStateBlockItem;
import com.railwayteam.railways.content.buffer.BlockStateBlockItemGroup;
import com.railwayteam.railways.content.conductor.ConductorCapItem;
import com.railwayteam.railways.multiloader.Env;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.registry.CRItems;
import com.railwayteam.railways.registry.neoforge.CRCreativeModeTabsImpl;
import com.railwayteam.railways.registry.neoforge.CRCreativeModeTabsRegistrateDisplayItemsGeneratorImpl;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyItem;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class CRCreativeModeTabs {
    public static ResourceKey<CreativeModeTab> getBaseTabKey() {
        return CRCreativeModeTabsImpl.getBaseTabKey();
    }

    public static ResourceKey<CreativeModeTab> getTracksTabKey() {
        return CRCreativeModeTabsImpl.getTracksTabKey();
    }

    public static ResourceKey<CreativeModeTab> getPalettesTabKey() {
        return CRCreativeModeTabsImpl.getPalettesTabKey();
    }

    public static void register() {
    }

    public static void devLogTabCounts() {
        try {
            CreateRegistrate reg = Railways.registrate();
            ResourceKey<CreativeModeTab> mainKey = CRCreativeModeTabs.getBaseTabKey();
            ResourceKey<CreativeModeTab> tracksKey = CRCreativeModeTabs.getTracksTabKey();
            ResourceKey<CreativeModeTab> palettesKey = CRCreativeModeTabs.getPalettesTabKey();
            int mainItems = 0;
            int mainBlocks = 0;
            int tracksItems = 0;
            int tracksBlocks = 0;
            int palettesItems = 0;
            int palettesBlocks = 0;
            for (RegistryEntry e : reg.getAll(Registries.ITEM)) {
                if (CRCreativeModeTabsRegistrateDisplayItemsGeneratorImpl.isInCreativeTab(e, mainKey)) {
                    ++mainItems;
                }
                if (CRCreativeModeTabsRegistrateDisplayItemsGeneratorImpl.isInCreativeTab(e, tracksKey)) {
                    ++tracksItems;
                }
                if (!CRCreativeModeTabsRegistrateDisplayItemsGeneratorImpl.isInCreativeTab(e, palettesKey)) continue;
                ++palettesItems;
            }
            for (RegistryEntry e : reg.getAll(Registries.BLOCK)) {
                if (CRCreativeModeTabsRegistrateDisplayItemsGeneratorImpl.isInCreativeTab(e, mainKey)) {
                    ++mainBlocks;
                }
                if (CRCreativeModeTabsRegistrateDisplayItemsGeneratorImpl.isInCreativeTab(e, tracksKey)) {
                    ++tracksBlocks;
                }
                if (!CRCreativeModeTabsRegistrateDisplayItemsGeneratorImpl.isInCreativeTab(e, palettesKey)) continue;
                ++palettesBlocks;
            }
            Railways.LOGGER.info("[Dev] Creative tab assignment -> main: {} items, {} blocks | tracks: {} items, {} blocks | palettes: {} items, {} blocks", new Object[]{mainItems, mainBlocks, tracksItems, tracksBlocks, palettesItems, palettesBlocks});
        }
        catch (Throwable t) {
            Railways.LOGGER.debug("[Dev] Failed to log creative tab assignment counts", t);
        }
    }

    public record TabInfo(ResourceKey<CreativeModeTab> key, CreativeModeTab tab) {
    }

    public static final class RegistrateDisplayItemsGenerator
    implements CreativeModeTab.DisplayItemsGenerator {
        private final Tabs tab;
        private static final DyeColor[] COLOR_ORDER = new DyeColor[]{DyeColor.RED, DyeColor.ORANGE, DyeColor.YELLOW, DyeColor.LIME, DyeColor.GREEN, DyeColor.LIGHT_BLUE, DyeColor.CYAN, DyeColor.BLUE, DyeColor.PURPLE, DyeColor.MAGENTA, DyeColor.PINK, DyeColor.BROWN, DyeColor.BLACK, DyeColor.GRAY, DyeColor.LIGHT_GRAY, DyeColor.WHITE};

        public RegistrateDisplayItemsGenerator(Tabs tab) {
            this.tab = tab;
        }

        private static Predicate<Item> makeExclusionPredicate() {
            ReferenceOpenHashSet exclusions = new ReferenceOpenHashSet();
            List<ItemProviderEntry> simpleExclusions = List.of();
            for (ItemProviderEntry entry : simpleExclusions) {
                exclusions.add(entry.asItem());
            }
            return arg_0 -> RegistrateDisplayItemsGenerator.lambda$makeExclusionPredicate$0((Set)exclusions, arg_0);
        }

        private static List<ItemOrdering> makeOrderings() {
            ReferenceArrayList orderings = new ReferenceArrayList();
            Map<ItemProviderEntry, ItemProviderEntry> simpleBeforeOrderings = Map.of();
            Map<BlockEntry<TrackBlock>, BlockEntry<TrackBlock>> simpleAfterOrderings = Map.of(CRBlocks.CONDUCTOR_WHISTLE_FLAG, (ItemProviderEntry)CRItems.ITEM_CONDUCTOR_CAP.get(DyeColor.RED), CRItems.REMOTE_LENS, CRBlocks.CONDUCTOR_WHISTLE_FLAG, CRBlocks.CONDUCTOR_VENT, CRItems.REMOTE_LENS, CRBlocks.MANGROVE_TRACK, CRBlocks.SPRUCE_TRACK, CRBlocks.CRIMSON_TRACK, CRBlocks.WARPED_TRACK);
            simpleBeforeOrderings.forEach((arg_0, arg_1) -> RegistrateDisplayItemsGenerator.lambda$makeOrderings$1((List)orderings, arg_0, arg_1));
            simpleAfterOrderings.forEach((arg_0, arg_1) -> RegistrateDisplayItemsGenerator.lambda$makeOrderings$2((List)orderings, arg_0, arg_1));
            return orderings;
        }

        private static Function<Item, ItemStack> makeStackFunc() {
            Reference2ReferenceOpenHashMap factories = new Reference2ReferenceOpenHashMap();
            Map<ItemProviderEntry, Function> simpleFactories = Map.of();
            simpleFactories.forEach((arg_0, arg_1) -> RegistrateDisplayItemsGenerator.lambda$makeStackFunc$3((Map)factories, arg_0, arg_1));
            return arg_0 -> RegistrateDisplayItemsGenerator.lambda$makeStackFunc$4((Map)factories, arg_0);
        }

        private static Function<Item, CreativeModeTab.TabVisibility> makeVisibilityFunc() {
            Reference2ObjectOpenHashMap visibilities = new Reference2ObjectOpenHashMap();
            Map<ItemProviderEntry, CreativeModeTab.TabVisibility> simpleVisibilities = Map.of();
            simpleVisibilities.forEach((arg_0, arg_1) -> RegistrateDisplayItemsGenerator.lambda$makeVisibilityFunc$5((Map)visibilities, arg_0, arg_1));
            for (ItemEntry<ConductorCapItem> entry : CRItems.ITEM_CONDUCTOR_CAP.values()) {
                ConductorCapItem item = (ConductorCapItem)((Object)entry.get());
                if (item.color == DyeColor.RED) continue;
                visibilities.put(item, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
            }
            return arg_0 -> RegistrateDisplayItemsGenerator.lambda$makeVisibilityFunc$6((Map)visibilities, arg_0);
        }

        public void accept(CreativeModeTab.ItemDisplayParameters pParameters, CreativeModeTab.Output output) {
            Predicate<Item> exclusionPredicate = RegistrateDisplayItemsGenerator.makeExclusionPredicate();
            List<ItemOrdering> orderings = RegistrateDisplayItemsGenerator.makeOrderings();
            Function<Item, ItemStack> stackFunc = RegistrateDisplayItemsGenerator.makeStackFunc();
            Function<Item, CreativeModeTab.TabVisibility> visibilityFunc = RegistrateDisplayItemsGenerator.makeVisibilityFunc();
            ResourceKey<CreativeModeTab> tab = this.tab.getKey();
            LinkedList<Item> items = new LinkedList<Item>();
            Predicate is3d = (Predicate)Env.unsafeRunForDist(() -> () -> item -> Minecraft.getInstance().getItemRenderer().getModel(new ItemStack((ItemLike)item), null, null, 0).isGui3d(), () -> () -> item -> false);
            items.addAll(this.collectItems(tab, is3d, true, exclusionPredicate));
            items.addAll(this.collectBlocks(tab, exclusionPredicate));
            items.addAll(this.collectItems(tab, is3d, false, exclusionPredicate));
            Railways.LOGGER.info("[Dev] Creative tab {} will display {} entries", (Object)tab.location(), (Object)items.size());
            RegistrateDisplayItemsGenerator.applyOrderings(items, orderings);
            RegistrateDisplayItemsGenerator.outputAll(output, items, stackFunc, visibilityFunc);
        }

        private List<Item> collectBlocks(ResourceKey<CreativeModeTab> tab, Predicate<Item> exclusionPredicate) {
            ReferenceArrayList items = new ReferenceArrayList();
            for (RegistryEntry entry : Railways.registrate().getAll(Registries.BLOCK)) {
                Block block;
                Item item;
                if (!RegistrateDisplayItemsGenerator.isInCreativeTab(entry, tab)) continue;
                Object obj = entry.get();
                if (obj instanceof BlockStateBlockItemGroup.GroupedBlock) {
                    BlockStateBlockItemGroup<?, ?> group = BlockStateBlockItemGroup.get(entry.getId());
                    for (ItemEntry<BlockStateBlockItem<?>> itemEntry : group.getItems()) {
                        Item item2 = ((Item)itemEntry.get()).asItem();
                        if (item2 == Items.AIR || exclusionPredicate.test(item2)) continue;
                        items.add(item2);
                    }
                    continue;
                }
                if (!(obj instanceof Block) || (item = (block = (Block)obj).asItem()) == Items.AIR || exclusionPredicate.test(item)) continue;
                items.add(item);
            }
            items = new ReferenceArrayList((ReferenceCollection)new ReferenceLinkedOpenHashSet((Collection)items));
            return items;
        }

        private List<Item> collectItems(ResourceKey<CreativeModeTab> tab, Predicate<Item> is3d, boolean special, Predicate<Item> exclusionPredicate) {
            ReferenceArrayList items = new ReferenceArrayList();
            for (RegistryEntry entry : Railways.registrate().getAll(Registries.ITEM)) {
                Item item;
                if (!RegistrateDisplayItemsGenerator.isInCreativeTab(entry, tab) || (item = (Item)entry.get()) instanceof BlockItem || is3d.test(item) != special || exclusionPredicate.test(item)) continue;
                items.add(item);
            }
            return items;
        }

        private static boolean isInCreativeTab(RegistryEntry<?, ?> entry, ResourceKey<CreativeModeTab> tab) {
            return CRCreativeModeTabsRegistrateDisplayItemsGeneratorImpl.isInCreativeTab(entry, tab);
        }

        private static void applyOrderings(List<Item> items, List<ItemOrdering> orderings) {
            for (ItemOrdering ordering : orderings) {
                int anchorIndex = items.indexOf(ordering.anchor());
                if (anchorIndex == -1) continue;
                Item item = ordering.item();
                int itemIndex = items.indexOf(item);
                if (itemIndex != -1) {
                    items.remove(itemIndex);
                    if (itemIndex < anchorIndex) {
                        --anchorIndex;
                    }
                }
                if (ordering.type() == ItemOrdering.Type.AFTER) {
                    items.add(anchorIndex + 1, item);
                    continue;
                }
                items.add(anchorIndex, item);
            }
        }

        private static void outputAll(CreativeModeTab.Output output, List<Item> items, Function<Item, ItemStack> stackFunc, Function<Item, CreativeModeTab.TabVisibility> visibilityFunc) {
            for (Item item : items) {
                output.accept(stackFunc.apply(item), visibilityFunc.apply(item));
            }
        }

        private static /* synthetic */ CreativeModeTab.TabVisibility lambda$makeVisibilityFunc$6(Map visibilities, Item item) {
            CreativeModeTab.TabVisibility visibility = (CreativeModeTab.TabVisibility)visibilities.get(item);
            if (visibility != null) {
                return visibility;
            }
            return CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS;
        }

        private static /* synthetic */ void lambda$makeVisibilityFunc$5(Map visibilities, ItemProviderEntry entry, CreativeModeTab.TabVisibility factory) {
            visibilities.put(entry.asItem(), factory);
        }

        private static /* synthetic */ ItemStack lambda$makeStackFunc$4(Map factories, Item item) {
            Function factory = (Function)factories.get(item);
            if (factory != null) {
                return (ItemStack)factory.apply(item);
            }
            return new ItemStack((ItemLike)item);
        }

        private static /* synthetic */ void lambda$makeStackFunc$3(Map factories, ItemProviderEntry entry, Function factory) {
            factories.put(entry.asItem(), factory);
        }

        private static /* synthetic */ void lambda$makeOrderings$2(List orderings, ItemProviderEntry entry, ItemProviderEntry otherEntry) {
            orderings.add(ItemOrdering.after(entry.asItem(), otherEntry.asItem()));
        }

        private static /* synthetic */ void lambda$makeOrderings$1(List orderings, ItemProviderEntry entry, ItemProviderEntry otherEntry) {
            orderings.add(ItemOrdering.before(entry.asItem(), otherEntry.asItem()));
        }

        private static /* synthetic */ boolean lambda$makeExclusionPredicate$0(Set exclusions, Item item) {
            return exclusions.contains(item) || item instanceof SequencedAssemblyItem;
        }

        private record ItemOrdering(Item item, Item anchor, Type type) {
            public static ItemOrdering before(Item item, Item anchor) {
                return new ItemOrdering(item, anchor, Type.BEFORE);
            }

            public static ItemOrdering after(Item item, Item anchor) {
                return new ItemOrdering(item, anchor, Type.AFTER);
            }

            public static enum Type {
                BEFORE,
                AFTER;

            }
        }
    }

    public static enum Tabs {
        MAIN(CRCreativeModeTabs::getBaseTabKey),
        TRACK(CRCreativeModeTabs::getTracksTabKey),
        PALETTES(CRCreativeModeTabs::getPalettesTabKey);

        private final Supplier<ResourceKey<CreativeModeTab>> keySupplier;

        private Tabs(Supplier<ResourceKey<CreativeModeTab>> keySupplier) {
            this.keySupplier = keySupplier;
        }

        public ResourceKey<CreativeModeTab> getKey() {
            return this.keySupplier.get();
        }
    }
}

