/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.neoforge.datagen;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.base.data.RailwaysHatOffsetGenerator;
import com.railwayteam.railways.base.data.recipe.RailwaysSequencedAssemblyRecipeGen;
import com.railwayteam.railways.base.data.recipe.RailwaysStandardRecipeGen;
import com.railwayteam.railways.base.data.recipe.neoforge.RailwaysMechanicalCraftingRecipeGenImpl;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="railways", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator.PackGenerator pack = event.getGenerator().getVanillaPack(true);
        Railways.gatherData(pack);
        boolean runServer = event.includeServer();
        DataGenerator generator = event.getGenerator();
        CompletableFuture lookupProvider = event.getLookupProvider();
        PackOutput packOutput = generator.getPackOutput();
        final RailwaysSequencedAssemblyRecipeGen sequencedAssembly = RailwaysSequencedAssemblyRecipeGen.create(packOutput, lookupProvider);
        final RailwaysStandardRecipeGen standardRecipes = RailwaysStandardRecipeGen.create(packOutput, lookupProvider);
        final RailwaysMechanicalCraftingRecipeGenImpl mechanicalCrafting = RailwaysMechanicalCraftingRecipeGenImpl.createImpl(packOutput, lookupProvider);
        generator.addProvider(runServer, (DataProvider)new RecipeProvider(packOutput, lookupProvider){

            protected void buildRecipes(@NotNull RecipeOutput output) {
                sequencedAssembly.buildRecipes(output);
                standardRecipes.buildRecipes(output);
                mechanicalCrafting.buildRecipes(output);
            }
        });
        generator.addProvider(runServer, (DataProvider)new RailwaysHatOffsetGenerator(packOutput, lookupProvider));
    }
}

