/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.neoforge;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.multiloader.neoforge.CustomPayloadWrapper;
import com.railwayteam.railways.registry.CRPackets;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class RailwaysNetworking {
    private static final ResourceLocation C2S_PACKET_ID = ResourceLocation.fromNamespaceAndPath((String)"railways", (String)"c2s");
    private static final ResourceLocation S2C_PACKET_ID = ResourceLocation.fromNamespaceAndPath((String)"railways", (String)"s2c");

    public static void registerPayloads(RegisterPayloadHandlersEvent event) {
        Railways.LOGGER.info("Registering Railways network payloads...");
        PayloadRegistrar registrar = event.registrar("railways").versioned("1.0.0").optional();
        registrar.playToServer(CustomPayloadWrapper.type(C2S_PACKET_ID), CustomPayloadWrapper.codec(C2S_PACKET_ID), (payload, context) -> {});
        registrar.playToClient(CustomPayloadWrapper.type(S2C_PACKET_ID), CustomPayloadWrapper.codec(S2C_PACKET_ID), (payload, context) -> context.enqueueWork(() -> {
            Minecraft mc = Minecraft.getInstance();
            if (mc.level != null) {
                CRPackets.PACKETS.handleS2CPacket(mc, payload.data());
            }
        }));
        Railways.LOGGER.info("Railways network payloads registered successfully");
    }
}

