/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin.compat.voicechat;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.railwayteam.railways.annotation.mixin.ConditionalMixin;
import com.railwayteam.railways.compat.Mods;
import com.railwayteam.railways.content.conductor.ConductorPossessionController;
import java.lang.reflect.Method;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@ConditionalMixin(mods={Mods.VOICECHAT})
@Mixin(targets={"de.maxhenkel.voicechat.plugins.impl.audiochannel.EntityAudioChannelImpl"})
public class EntityAudioChannelImplMixin {
    @WrapOperation(method={"broadcast"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getEyePosition()Lnet/minecraft/world/phys/Vec3;")})
    private Vec3 useConductorSpyPosition(Entity instance, Operation<Vec3> original) {
        if (instance instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)instance;
            if (ConductorPossessionController.isPossessingConductor(instance)) {
                return serverPlayer.getCamera().getEyePosition();
            }
        }
        return (Vec3)original.call(new Object[]{instance});
    }

    @WrapOperation(method={"send([B)V", "send(Lde/maxhenkel/voicechat/api/packets/MicrophonePacket;)V", "flush"}, at={@At(value="INVOKE", target="Lde/maxhenkel/voicechat/api/Entity;getUuid()Ljava/util/UUID;")}, remap=false)
    private UUID useConductorSpyUUID(Object instance, Operation<UUID> original) {
        try {
            ServerPlayer serverPlayer;
            Method getEntity = instance.getClass().getMethod("getEntity", new Class[0]);
            Object entityObj = getEntity.invoke(instance, new Object[0]);
            if (entityObj instanceof ServerPlayer && ConductorPossessionController.isPossessingConductor((Entity)(serverPlayer = (ServerPlayer)entityObj))) {
                return serverPlayer.getCamera().getUUID();
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return (UUID)original.call(new Object[]{instance});
    }
}

