/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin.client;

import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.util.EntityUtils;
import com.simibubi.create.content.equipment.toolbox.ToolboxHandlerClient;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={ToolboxHandlerClient.class}, remap=false)
public class MixinToolboxHandlerClient {
    @Unique
    @Nullable
    private static ConductorEntity railways$conductorForSelectedSlot;
    @Unique
    private static int railways$currentRenderedSlot;

    @Unique
    private static ConductorEntity railways$getConductorForSlot(int slot) {
        String slotKey;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        CompoundTag toolboxData = EntityUtils.getPersistentData((Entity)player).getCompound("CreateToolboxData");
        CompoundTag data = toolboxData.getCompound(slotKey = String.valueOf(slot));
        if (!data.hasUUID("EntityUUID")) {
            return null;
        }
        UUID uuid = data.getUUID("EntityUUID");
        ConductorEntity conductor = null;
        for (ConductorEntity ce : (Set)ConductorEntity.WITH_TOOLBOXES.get((LevelAccessor)mc.level)) {
            if (!ce.getUUID().equals(uuid)) continue;
            conductor = ce;
            break;
        }
        return conductor;
    }

    @ModifyVariable(method={"onKeyInput"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/equipment/toolbox/ToolboxHandler;getMaxRange(Lnet/minecraft/world/entity/player/Player;)D", remap=true))
    private static BlockPos railways$useConductorToolboxDistance(BlockPos pos) {
        ConductorEntity conductor;
        railways$conductorForSelectedSlot = conductor = MixinToolboxHandlerClient.railways$getConductorForSlot(Minecraft.getInstance().player.getInventory().selected);
        return conductor == null ? pos : conductor.blockPosition();
    }

    @ModifyVariable(method={"onKeyInput"}, remap=false, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/level/Level;getBlockEntity(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/entity/BlockEntity;", remap=true))
    private static BlockEntity railways$getConductorToolbox(BlockEntity be) {
        ConductorEntity conductor = railways$conductorForSelectedSlot;
        return conductor == null ? be : conductor.getToolbox();
    }

    @ModifyArg(method={"renderOverlay"}, remap=false, at=@At(value="INVOKE", target="Ljava/lang/String;valueOf(I)Ljava/lang/String;"))
    private static int railways$grabSlot(int slot) {
        railways$currentRenderedSlot = slot;
        return slot;
    }

    @ModifyVariable(method={"renderOverlay"}, remap=false, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/nbt/NbtUtils;readBlockPos(Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/core/BlockPos;", remap=true))
    private static BlockPos railways$useConductorToolboxForBackground(BlockPos pos) {
        ConductorEntity conductor = MixinToolboxHandlerClient.railways$getConductorForSlot(railways$currentRenderedSlot);
        return conductor == null ? pos : conductor.blockPosition();
    }
}

