/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.compat.Mods;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.content.conductor.ConductorEntityModel;
import com.railwayteam.railways.content.conductor.ConductorRenderer;
import com.railwayteam.railways.mixin.client.AccessorEntity;
import com.railwayteam.railways.mixin.client.AccessorWalkAnimationState;
import com.railwayteam.railways.registry.CREntities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerRenderer.class})
public abstract class MixinPlayerRenderer
extends LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private ConductorEntity visualEntity;

    private MixinPlayerRenderer(EntityRendererProvider.Context context, PlayerModel<AbstractClientPlayer> model, float shadowRadius) {
        super(context, model, shadowRadius);
    }

    @Inject(method={"render(Lnet/minecraft/client/player/AbstractClientPlayer;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderConductorInstead(AbstractClientPlayer entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight, CallbackInfo ci) {
        if (!ConductorEntity.isPlayerDisguised((Player)entity)) {
            this.shadowRadius = 0.5f;
            return;
        }
        this.shadowRadius = 0.2f;
        Minecraft mc = Minecraft.getInstance();
        if (entity.isLocalPlayer() && mc.options.getCameraType().isFirstPerson() && Mods.FIGURA.isLoaded) {
            return;
        }
        ci.cancel();
        if (this.visualEntity == null) {
            this.visualEntity = new ConductorEntity((EntityType<? extends AbstractGolem>)((EntityType)CREntities.CONDUCTOR.get()), entity.level());
        }
        MixinPlayerRenderer.railways$transformVisualConductor(entity, this.visualEntity);
        this.visualEntity.visualBaseModel = (PlayerModel)this.getModel();
        this.visualEntity.visualBaseModel.crouching = entity.isCrouching();
        this.visualEntity.visualBaseModel.swimAmount = entity.getSwimAmount(partialTicks);
        this.visualEntity.visualBaseEntity = entity;
        Minecraft.getInstance().getEntityRenderDispatcher().render((Entity)this.visualEntity, 0.0, 0.0, 0.0, 0.0f, partialTicks, matrixStack, buffer, packedLight);
    }

    private static void railways$transformVisualConductor(AbstractClientPlayer player, ConductorEntity conductor) {
        conductor.xo = player.xo;
        conductor.yo = player.yo;
        conductor.zo = player.zo;
        conductor.xOld = player.xOld;
        conductor.yOld = player.yOld;
        conductor.zOld = player.zOld;
        conductor.xRotO = player.xRotO;
        conductor.yRotO = player.yRotO;
        ((AccessorEntity)((Object)conductor)).setXRot(player.getXRot());
        ((AccessorEntity)((Object)conductor)).setYRot(player.getYRot());
        conductor.yHeadRot = player.yHeadRot;
        conductor.yBodyRot = player.yBodyRot;
        conductor.yBodyRotO = player.yBodyRotO;
        conductor.yHeadRotO = player.yHeadRotO;
        ((AccessorWalkAnimationState)conductor.walkAnimation).setPosition(player.walkAnimation.position());
        conductor.walkAnimation.setSpeed(player.walkAnimation.speed());
        ((AccessorWalkAnimationState)conductor.walkAnimation).setSpeedOld(((AccessorWalkAnimationState)player.walkAnimation).getSpeedOld());
        conductor.tickCount = player.tickCount;
        conductor.setOnGround(player.onGround());
        conductor.setItemSlot(EquipmentSlot.HEAD, player.getItemBySlot(EquipmentSlot.HEAD));
        ItemStack chest = player.getItemBySlot(EquipmentSlot.CHEST);
        if (chest.getItem() == Items.ELYTRA) {
            conductor.setItemSlot(EquipmentSlot.CHEST, chest);
        } else {
            conductor.setItemSlot(EquipmentSlot.CHEST, ItemStack.EMPTY);
        }
        conductor.setSharedFlag(7, player.isFallFlying());
    }

    @Inject(method={"renderRightHand"}, at={@At(value="HEAD")}, cancellable=true)
    private void railways$renderRightHand(PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, AbstractClientPlayer player, CallbackInfo ci) {
        if (!ConductorEntity.isPlayerDisguised((Player)player)) {
            return;
        }
        ci.cancel();
        if (this.visualEntity == null) {
            this.visualEntity = new ConductorEntity((EntityType<? extends AbstractGolem>)((EntityType)CREntities.CONDUCTOR.get()), player.level());
        }
        MixinPlayerRenderer.railways$transformVisualConductor(player, this.visualEntity);
        this.visualEntity.visualBaseModel = (PlayerModel)this.getModel();
        this.visualEntity.visualBaseModel.crouching = player.isCrouching();
        this.visualEntity.visualBaseModel.swimAmount = player.getSwimAmount(0.0f);
        this.visualEntity.visualBaseEntity = player;
        EntityRenderer entityRenderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)this.visualEntity);
        if (entityRenderer instanceof ConductorRenderer) {
            ConductorRenderer conductorRenderer = (ConductorRenderer)entityRenderer;
            this.railways$renderHand(matrixStack, buffer, combinedLight, this.visualEntity, ((ConductorEntityModel)conductorRenderer.getModel()).rightArm, this.visualEntity.visualBaseModel, (ConductorEntityModel)conductorRenderer.getModel(), conductorRenderer);
        }
    }

    @Inject(method={"renderLeftHand"}, at={@At(value="HEAD")}, cancellable=true)
    private void railways$renderLeftHand(PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, AbstractClientPlayer player, CallbackInfo ci) {
        if (!ConductorEntity.isPlayerDisguised((Player)player)) {
            return;
        }
        ci.cancel();
        if (this.visualEntity == null) {
            this.visualEntity = new ConductorEntity((EntityType<? extends AbstractGolem>)((EntityType)CREntities.CONDUCTOR.get()), player.level());
        }
        MixinPlayerRenderer.railways$transformVisualConductor(player, this.visualEntity);
        this.visualEntity.visualBaseModel = (PlayerModel)this.getModel();
        this.visualEntity.visualBaseModel.crouching = player.isCrouching();
        this.visualEntity.visualBaseModel.swimAmount = player.getSwimAmount(0.0f);
        this.visualEntity.visualBaseEntity = player;
        EntityRenderer entityRenderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)this.visualEntity);
        if (entityRenderer instanceof ConductorRenderer) {
            ConductorRenderer conductorRenderer = (ConductorRenderer)entityRenderer;
            this.railways$renderHand(matrixStack, buffer, combinedLight, this.visualEntity, ((ConductorEntityModel)conductorRenderer.getModel()).leftArm, this.visualEntity.visualBaseModel, (ConductorEntityModel)conductorRenderer.getModel(), conductorRenderer);
        }
    }

    private void railways$renderHand(PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, ConductorEntity conductor, ModelPart rendererArm, PlayerModel<?> playermodel, ConductorEntityModel<ConductorEntity> conductorModel, ConductorRenderer conductorRenderer) {
        playermodel.attackTime = 0.0f;
        playermodel.crouching = false;
        playermodel.swimAmount = 0.0f;
        conductorModel.setupAnim(conductor, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        rendererArm.xRot = 0.0f;
        matrixStack.pushPose();
        matrixStack.translate(0.0, -0.3, 0.0);
        rendererArm.render(matrixStack, buffer.getBuffer(RenderType.entitySolid((ResourceLocation)conductorRenderer.getTextureLocation(conductor))), combinedLight, OverlayTexture.NO_OVERLAY);
        matrixStack.popPose();
    }
}

