/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin.client;

import com.mojang.authlib.GameProfile;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.annotation.mixin.DevEnvMixin;
import com.railwayteam.railways.util.DevCapeUtils;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerInfo.class})
public class MixinPlayerInfo {
    @Shadow
    @Final
    private GameProfile profile;
    @Unique
    private boolean railways$texturesLoaded;
    @Unique
    private static final ResourceLocation DEV_CAPE = Railways.asResource("textures/misc/dev_cape.png");
    @Unique
    private static final ResourceLocation DEV_SKIN = Railways.asResource("textures/misc/devenv_skin.png");

    @DevEnvMixin
    @Inject(method={"getSkin"}, at={@At(value="RETURN")}, cancellable=true)
    private void replaceSkinTexture(CallbackInfoReturnable<PlayerSkin> cir) {
        PlayerSkin originalSkin = (PlayerSkin)cir.getReturnValue();
        PlayerSkin devSkin = new PlayerSkin(DEV_SKIN, null, originalSkin.capeTexture(), originalSkin.elytraTexture(), PlayerSkin.Model.WIDE, originalSkin.secure());
        cir.setReturnValue((Object)devSkin);
    }

    @Inject(method={"getSkin"}, at={@At(value="RETURN")}, cancellable=true)
    private void addDevCape(CallbackInfoReturnable<PlayerSkin> cir) {
        if (!this.railways$texturesLoaded && DevCapeUtils.INSTANCE.useDevCape(this.profile.getId())) {
            this.railways$texturesLoaded = true;
            PlayerSkin originalSkin = (PlayerSkin)cir.getReturnValue();
            PlayerSkin skinWithCape = new PlayerSkin(originalSkin.texture(), originalSkin.textureUrl(), DEV_CAPE, originalSkin.elytraTexture(), originalSkin.model(), originalSkin.secure());
            cir.setReturnValue((Object)skinWithCape);
        }
    }
}

