/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.railwayteam.railways.content.conductor.ConductorEntity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class MixinPlayer
extends LivingEntity {
    private boolean wasDisguised = false;

    private MixinPlayer(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"getEyeHeight"}, at={@At(value="RETURN")}, cancellable=true, require=0)
    private void conductorsAreSmaller(Pose pose, EntityDimensions dimensions, CallbackInfoReturnable<Float> cir) {
        if (ConductorEntity.isPlayerDisguised((Player)this)) {
            if (pose == Pose.SLEEPING || pose == Pose.FALL_FLYING || pose == Pose.SPIN_ATTACK || pose == Pose.SWIMMING || pose == Pose.DYING) {
                return;
            }
            cir.setReturnValue((Object)Float.valueOf(cir.getReturnValueF() * 0.7037037f));
        }
    }

    @Inject(method={"getDimensions"}, at={@At(value="RETURN")}, cancellable=true)
    private void shrinkConductorPlayer(Pose pose, CallbackInfoReturnable<EntityDimensions> cir) {
        if (ConductorEntity.isPlayerDisguised((Player)this)) {
            if (pose == Pose.SLEEPING || pose == Pose.FALL_FLYING || pose == Pose.SPIN_ATTACK || pose == Pose.SWIMMING || pose == Pose.DYING) {
                return;
            }
            EntityDimensions dimensions = (EntityDimensions)cir.getReturnValue();
            cir.setReturnValue((Object)dimensions.scale(1.0f, 0.8333334f));
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void updateDimensions(CallbackInfo ci) {
        boolean isDisguised = ConductorEntity.isPlayerDisguised((Player)this);
        if (isDisguised != this.wasDisguised) {
            this.wasDisguised = isDisguised;
            this.refreshDimensions();
        }
    }
}

