/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.switches;

import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.content.switches.TrackSwitchBlock;
import com.railwayteam.railways.mixin.client.AccessorControlsHandler;
import com.railwayteam.railways.registry.CRGuiTextures;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.actors.trainControls.ControlsHandler;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameType;
import org.jetbrains.annotations.Nullable;

public class TrainHUDSwitchExtension {
    @Nullable
    public static TrackSwitchBlock.SwitchState switchState;
    public static boolean isAutomaticSwitch;
    public static boolean isWrong;
    public static boolean isLocked;
    static LerpedFloat switchProgress;

    public static void tick() {
        if (AccessorControlsHandler.getEntityRef().get() == null) {
            switchState = null;
        }
        switchProgress.chase(switchState != null ? 1.0 : 0.0, 0.5, LerpedFloat.Chaser.EXP);
        switchProgress.tickChaser();
    }

    private static Carriage getCarriage() {
        AbstractContraptionEntity abstractContraptionEntity = ControlsHandler.getContraption();
        if (!(abstractContraptionEntity instanceof CarriageContraptionEntity)) {
            return null;
        }
        CarriageContraptionEntity cce = (CarriageContraptionEntity)abstractContraptionEntity;
        return cce.getCarriage();
    }

    public static void renderOverlay(GuiGraphics graphics, float partialTicks, int width, int height) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.options.hideGui || mc.gameMode.getPlayerMode() == GameType.SPECTATOR) {
            return;
        }
        AbstractContraptionEntity abstractContraptionEntity = ControlsHandler.getContraption();
        if (!(abstractContraptionEntity instanceof CarriageContraptionEntity)) {
            return;
        }
        CarriageContraptionEntity cce = (CarriageContraptionEntity)abstractContraptionEntity;
        Carriage carriage = cce.getCarriage();
        if (carriage == null) {
            return;
        }
        Entity cameraEntity = Minecraft.getInstance().getCameraEntity();
        if (cameraEntity == null) {
            return;
        }
        BlockPos localPos = ControlsHandler.getControlsPos();
        if (localPos == null) {
            return;
        }
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)(width / 2 - 91), (float)(height - 29), 0.0f);
        if (switchProgress.getValue(partialTicks) > 0.0f) {
            CRGuiTextures bg = isAutomaticSwitch ? CRGuiTextures.TRAIN_HUD_SWITCH_BRASS : CRGuiTextures.TRAIN_HUD_SWITCH_ANDESITE;
            bg.bind();
            graphics.blit(bg.location, 131, (int)((double)(-16.0f * switchProgress.getValue(partialTicks)) - 0.5), 0, (float)bg.startX, (float)bg.startY, bg.width, (int)((double)((float)bg.height * switchProgress.getValue(partialTicks)) + 0.5), 256, 256);
        }
        if ((double)switchProgress.getValue(partialTicks) > 0.99 && switchState != null) {
            switch (switchState) {
                case NORMAL: {
                    CRGuiTextures.getForSwitch(switchState, isWrong).render(graphics, 152, -13);
                    break;
                }
                case REVERSE_LEFT: {
                    CRGuiTextures.getForSwitch(switchState, isWrong).render(graphics, 142, -13);
                    break;
                }
                case REVERSE_RIGHT: {
                    CRGuiTextures.getForSwitch(switchState, isWrong).render(graphics, 162, -13);
                }
            }
            if (isLocked) {
                CRGuiTextures.TRAIN_HUD_SWITCH_LOCKED.render(graphics, 134, -13);
            }
        }
        poseStack.popPose();
    }

    static {
        isAutomaticSwitch = false;
        isWrong = false;
        isLocked = false;
        switchProgress = LerpedFloat.linear();
    }
}

