/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.smokestack.block;

import com.railwayteam.railways.content.smokestack.SmokestackStyle;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.util.ShapeWrapper;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class AbstractSmokeStackBlock<T extends SmartBlockEntity>
extends Block
implements ProperWaterloggedBlock,
IWrenchable,
IBE<T> {
    public static final EnumProperty<SmokestackStyle> STYLE = EnumProperty.create((String)"style", SmokestackStyle.class);
    public static final BooleanProperty ENABLED = BlockStateProperties.ENABLED;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected final ShapeWrapper shape;
    final String variant;

    public AbstractSmokeStackBlock(BlockBehaviour.Properties properties, ShapeWrapper shape, String variant) {
        super(properties);
        this.registerDefaultState(this.makeDefaultState());
        this.shape = shape;
        this.variant = variant;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shape.get();
    }

    protected BlockState makeDefaultState() {
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(STYLE, (Comparable)((Object)SmokestackStyle.STEEL))).setValue((Property)ENABLED, (Comparable)Boolean.valueOf(true))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{STYLE}).add(new Property[]{ENABLED}).add(new Property[]{POWERED}).add(new Property[]{WATERLOGGED});
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        if (this.variant.equals("diesel") || this.variant.equals("caboosestyle")) {
            return super.getCloneItemStack(level, pos, state);
        }
        return CRBlocks.SMOKESTACK_GROUP.get(this.variant).get((SmokestackStyle)((Object)state.getValue(STYLE))).asStack();
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return this.fluidState(state);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = this.defaultBlockState();
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        blockstate = (BlockState)blockstate.setValue(STYLE, (Comparable)((Object)SmokestackStyle.STEEL));
        if (context.getLevel().hasNeighborSignal(context.getClickedPos())) {
            blockstate = (BlockState)((BlockState)blockstate.setValue((Property)ENABLED, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)blockstate.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        this.updateWater(level, state, currentPos);
        return state;
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pPlayer.getItemInHand(pHand).is(AllTags.commonItemTag((String)"tools/wrench"))) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        pState = (BlockState)pState.cycle((Property)ENABLED);
        pLevel.setBlock(pPos, pState, 2);
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            pLevel.scheduleTick(pPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)pLevel));
        }
        return ItemInteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
        if (!level.isClientSide) {
            boolean shouldBeEnabled;
            boolean powered = level.hasNeighborSignal(pos);
            boolean bl = shouldBeEnabled = !powered;
            if (powered != (Boolean)state.getValue((Property)POWERED)) {
                if ((Boolean)state.getValue((Property)ENABLED) != shouldBeEnabled) {
                    state = (BlockState)state.setValue((Property)ENABLED, (Comparable)Boolean.valueOf(shouldBeEnabled));
                }
                level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 2);
                if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
                    level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
                }
            }
        }
    }

    public Item asItem() {
        return super.asItem();
    }
}

