/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.semaphore;

import com.mojang.serialization.MapCodec;
import com.railwayteam.railways.config.CRConfigs;
import com.railwayteam.railways.content.semaphore.SemaphoreBlockEntity;
import com.railwayteam.railways.registry.CRBlockEntities;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.registry.CRShapes;
import com.railwayteam.railways.registry.CRTags;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import java.util.function.Predicate;
import net.createmod.catnip.ghostblock.GhostBlocks;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SemaphoreBlock
extends HorizontalDirectionalBlock
implements IBE<SemaphoreBlockEntity>,
IWrenchable {
    public static final MapCodec<SemaphoreBlock> CODEC = SemaphoreBlock.simpleCodec(SemaphoreBlock::new);
    public static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());
    public static final int girderPlacementHelperId = PlacementHelpers.register((IPlacementHelper)new GirderPlacementHelper());
    public static final BooleanProperty FLIPPED = BooleanProperty.create((String)"flipped");
    public static final BooleanProperty FULL = BooleanProperty.create((String)"full");
    public static final BooleanProperty UPSIDE_DOWN = BooleanProperty.create((String)"upside_down");

    public SemaphoreBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FLIPPED, (Comparable)Boolean.valueOf(false))).setValue((Property)FULL, (Comparable)Boolean.valueOf(false))).setValue((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends SemaphoreBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder.add(new Property[]{FACING}).add(new Property[]{FLIPPED}).add(new Property[]{FULL}).add(new Property[]{UPSIDE_DOWN}));
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        IPlacementHelper helper = PlacementHelpers.get((int)girderPlacementHelperId);
        if (helper.matchesItem(stack)) {
            ItemInteractionResult result = helper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)stack.getItem(), player, hand, ray);
            return result.consumesAction() ? result : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        Direction facing = context.getHorizontalDirection().getOpposite();
        Vec3 look = context.getPlayer().getLookAngle();
        Vec3 cross = look.cross(new Vec3(facing.step()));
        boolean flipped = cross.y < 0.0;
        boolean upside_down = context.getClickedFace() == Direction.DOWN && (Boolean)CRConfigs.server().semaphores.simplifiedPlacement.get() == false;
        return (BlockState)((BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)facing)).setValue((Property)FLIPPED, (Comparable)Boolean.valueOf(flipped))).setValue((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(upside_down));
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        BlockState rotated;
        Level world = context.getLevel();
        boolean upsideDownChanged = false;
        if (context.getClickedFace().getAxis() != Direction.Axis.Y) {
            if (context.getClickedFace() == state.getValue((Property)FACING)) {
                rotated = (BlockState)state.cycle((Property)FLIPPED);
            } else if (context.getClickedFace() == ((Direction)state.getValue((Property)FACING)).getOpposite() && !((Boolean)CRConfigs.server().semaphores.simplifiedPlacement.get()).booleanValue()) {
                rotated = (BlockState)state.cycle((Property)UPSIDE_DOWN);
                upsideDownChanged = true;
            } else {
                rotated = (BlockState)state.setValue((Property)FACING, (Comparable)context.getClickedFace());
            }
        } else {
            rotated = this.getRotatedBlockState(state, context.getClickedFace());
        }
        if (!rotated.canSurvive((LevelReader)world, context.getClickedPos())) {
            return InteractionResult.PASS;
        }
        KineticBlockEntity.switchToBlockState((Level)world, (BlockPos)context.getClickedPos(), (BlockState)this.updateAfterWrenched(rotated, context));
        if (upsideDownChanged) {
            BlockState rotatedState;
            BlockState blockState;
            int i;
            BlockPos currentPos = context.getClickedPos().below();
            for (i = 0; i < 16; ++i) {
                blockState = world.getBlockState(currentPos);
                if (CRBlocks.SEMAPHORE.has(blockState)) {
                    rotatedState = (BlockState)blockState.setValue((Property)UPSIDE_DOWN, (Comparable)((Boolean)rotated.getValue((Property)UPSIDE_DOWN)));
                    KineticBlockEntity.switchToBlockState((Level)world, (BlockPos)currentPos, (BlockState)Block.updateFromNeighbourShapes((BlockState)rotatedState, (LevelAccessor)world, (BlockPos)currentPos));
                } else if (!CRTags.AllBlockTags.SEMAPHORE_POLES.matches(blockState)) break;
                currentPos = currentPos.below();
            }
            currentPos = context.getClickedPos().above();
            for (i = 0; i < 16; ++i) {
                blockState = world.getBlockState(currentPos);
                if (CRBlocks.SEMAPHORE.has(blockState)) {
                    rotatedState = (BlockState)blockState.setValue((Property)UPSIDE_DOWN, (Comparable)((Boolean)rotated.getValue((Property)UPSIDE_DOWN)));
                    KineticBlockEntity.switchToBlockState((Level)world, (BlockPos)currentPos, (BlockState)Block.updateFromNeighbourShapes((BlockState)rotatedState, (LevelAccessor)world, (BlockPos)currentPos));
                } else if (!CRTags.AllBlockTags.SEMAPHORE_POLES.matches(blockState)) break;
                currentPos = currentPos.above();
            }
        }
        if (world.getBlockState(context.getClickedPos()) != state) {
            IWrenchable.playRotateSound((Level)world, (BlockPos)context.getClickedPos());
        }
        return InteractionResult.SUCCESS;
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockState rotatedState;
        BlockState blockState;
        int i;
        super.onPlace(state, world, pos, oldState, isMoving);
        BlockPos currentPos = pos.below();
        for (i = 0; i < 16; ++i) {
            blockState = world.getBlockState(currentPos);
            if (CRBlocks.SEMAPHORE.has(blockState)) {
                rotatedState = (BlockState)blockState.setValue((Property)UPSIDE_DOWN, (Comparable)((Boolean)state.getValue((Property)UPSIDE_DOWN)));
                KineticBlockEntity.switchToBlockState((Level)world, (BlockPos)currentPos, (BlockState)Block.updateFromNeighbourShapes((BlockState)rotatedState, (LevelAccessor)world, (BlockPos)currentPos));
            } else if (!CRTags.AllBlockTags.SEMAPHORE_POLES.matches(blockState)) break;
            currentPos = currentPos.below();
        }
        currentPos = pos.above();
        for (i = 0; i < 16; ++i) {
            blockState = world.getBlockState(currentPos);
            if (CRBlocks.SEMAPHORE.has(blockState)) {
                rotatedState = (BlockState)blockState.setValue((Property)UPSIDE_DOWN, (Comparable)((Boolean)state.getValue((Property)UPSIDE_DOWN)));
                KineticBlockEntity.switchToBlockState((Level)world, (BlockPos)currentPos, (BlockState)Block.updateFromNeighbourShapes((BlockState)rotatedState, (LevelAccessor)world, (BlockPos)currentPos));
            } else if (!CRTags.AllBlockTags.SEMAPHORE_POLES.matches(blockState)) break;
            currentPos = currentPos.above();
        }
    }

    public Class<SemaphoreBlockEntity> getBlockEntityClass() {
        return SemaphoreBlockEntity.class;
    }

    public BlockEntityType<? extends SemaphoreBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CRBlockEntities.SEMAPHORE.get();
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return CRShapes.SEMAPHORE.get((Direction)pState.getValue((Property)FACING));
    }

    public static class PlacementHelper
    implements IPlacementHelper {
        public Predicate<ItemStack> getItemPredicate() {
            return arg_0 -> CRBlocks.SEMAPHORE.isIn(arg_0);
        }

        public Predicate<BlockState> getStatePredicate() {
            return state -> CRBlocks.SEMAPHORE.has(state) || CRTags.AllBlockTags.SEMAPHORE_POLES.matches((BlockState)state);
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            Direction offsetDirection = ray.getLocation().subtract((Vec3)Vec3.atCenterOf((Vec3i)pos)).y < 0.0 ? Direction.DOWN : Direction.UP;
            BlockPos newPos = pos.relative(offsetDirection);
            BlockState newState = world.getBlockState(newPos);
            if (!newState.canBeReplaced()) {
                newPos = pos.relative(offsetDirection.getOpposite());
                newState = world.getBlockState(newPos);
            }
            if (newState.canBeReplaced()) {
                Direction facing = ray.getDirection();
                if (facing.getAxis() == Direction.Axis.Y) {
                    return PlacementOffset.fail();
                }
                Vec3 look = player.getLookAngle();
                Vec3 cross = look.cross(new Vec3(facing.step()));
                boolean flipped = cross.y < 0.0;
                boolean upsideDown = offsetDirection == Direction.DOWN && (Boolean)CRConfigs.server().semaphores.simplifiedPlacement.get() == false;
                return PlacementOffset.success((Vec3i)newPos, x -> (BlockState)((BlockState)((BlockState)x.setValue((Property)FLIPPED, (Comparable)Boolean.valueOf(flipped))).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)facing)).setValue((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(upsideDown)));
            }
            return PlacementOffset.fail();
        }

        public void displayGhost(PlacementOffset offset) {
            if (!offset.hasGhostState()) {
                return;
            }
            GhostBlocks.getInstance().showGhostState((Object)this, (BlockState)offset.getTransform().apply((BlockState)offset.getGhostState().setValue((Property)FULL, (Comparable)Boolean.valueOf(true)))).at(offset.getBlockPos()).breathingAlpha();
        }
    }

    public static class GirderPlacementHelper
    implements IPlacementHelper {
        public Predicate<ItemStack> getItemPredicate() {
            return CRTags.AllBlockTags.SEMAPHORE_POLES::matches;
        }

        public Predicate<BlockState> getStatePredicate() {
            return arg_0 -> CRBlocks.SEMAPHORE.has(arg_0);
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            Direction offsetDirection = ray.getLocation().subtract((Vec3)Vec3.atCenterOf((Vec3i)pos)).y < 0.0 ? Direction.DOWN : Direction.UP;
            BlockPos newPos = pos.relative(offsetDirection);
            BlockState newState = world.getBlockState(newPos);
            if (!newState.canBeReplaced()) {
                newPos = pos.relative(offsetDirection.getOpposite());
                newState = world.getBlockState(newPos);
            }
            if (newState.canBeReplaced()) {
                Direction facing = ray.getDirection();
                if (facing.getAxis() == Direction.Axis.Y) {
                    return PlacementOffset.fail();
                }
                return PlacementOffset.success((Vec3i)newPos);
            }
            return PlacementOffset.fail();
        }
    }
}

