/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.minecarts;

import com.railwayteam.railways.content.minecarts.MinecartBlock;
import com.railwayteam.railways.registry.CREntities;
import com.railwayteam.railways.registry.CRItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinecartWorkbench
extends MinecartBlock
implements MenuProvider {
    public static AbstractMinecart.Type TYPE = null;
    private final double VALID_RANGE = 32.0;
    private static final EntityTypeTest<Entity, MinecartWorkbench> test = EntityTypeTest.forClass(MinecartWorkbench.class);

    public static AbstractMinecart.Type getWorkbenchType() {
        if (TYPE == null) {
            TYPE = AbstractMinecart.Type.valueOf((String)"RAILWAY_WORKBENCH");
        }
        return TYPE;
    }

    public MinecartWorkbench(EntityType<?> type, Level level) {
        super(type, level, Blocks.CRAFTING_TABLE);
    }

    public MinecartWorkbench(Level level, double x, double y, double z) {
        super((EntityType)CREntities.CART_BLOCK.get(), level, x, y, z, Blocks.CRAFTING_TABLE);
    }

    public AbstractMinecart.Type getMinecartType() {
        return TYPE;
    }

    @NotNull
    public InteractionResult interact(@NotNull Player player, @NotNull InteractionHand hand) {
        InteractionResult ret = super.interact(player, hand);
        if (ret.consumesAction()) {
            return ret;
        }
        player.openMenu((MenuProvider)this);
        if (!player.level().isClientSide) {
            this.gameEvent((Holder)GameEvent.CONTAINER_OPEN, (Entity)player);
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int p_39954_, @NotNull Inventory inv, @NotNull Player player) {
        return new CraftingMenu(this, p_39954_, inv, ContainerLevelAccess.create((Level)player.level(), (BlockPos)this.blockPosition())){

            public boolean stillValid(@NotNull Player player) {
                return player.level().getEntities(test, player.getBoundingBox().inflate(32.0), Entity::isAlive).stream().anyMatch(e -> player.distanceToSqr((Entity)e) < 32.0);
            }
        };
    }

    public ItemStack getPickResult() {
        return CRItems.ITEM_BENCHCART.asStack();
    }
}

