/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.handcar.ik;

import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;

public class DoubleArmIK {
    public static Vec2 calculateJointOffset(Vec2 topPoint, Vec2 bottomPoint, double k, double g) {
        double d = DoubleArmIK.distance(topPoint, bottomPoint);
        Vec2 localIntersection = DoubleArmIK.getIntersection(d, k, g);
        double dx = topPoint.x - bottomPoint.x;
        double dy = topPoint.y - bottomPoint.y;
        double alpha = Mth.atan2((double)dx, (double)dy);
        double r = localIntersection.length();
        float theta = (float)(Mth.atan2((double)localIntersection.y, (double)(-localIntersection.x)) - alpha);
        float globalX = (float)r * Mth.cos((float)theta);
        float globalY = (float)r * Mth.sin((float)theta);
        return new Vec2(globalX, globalY);
    }

    private static double distance(Vec2 topPoint, Vec2 bottomPoint) {
        topPoint = topPoint.add(bottomPoint.negated());
        return topPoint.length();
    }

    private static Vec2 getIntersection(double d, double k, double g) {
        double g2 = g * g;
        double d2 = d * d;
        double k2 = k * k;
        double y = (g2 + d2 - k2) / (2.0 * d);
        double y2 = y * y;
        double x = Math.sqrt(g2 - y2);
        return new Vec2((float)x, (float)y);
    }
}

