/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.cycle_menu;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.content.bogey_menu.handler.BogeyMenuEventsHandler;
import com.railwayteam.railways.content.cycle_menu.TagCycleHandlerClient;
import com.railwayteam.railways.mixin.client.AccessorToolboxHandlerClient;
import com.railwayteam.railways.registry.CRKeys;
import com.railwayteam.railways.util.client.ClientUtils;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.List;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class RadialTagCycleMenu
extends AbstractSimiScreen {
    private int ticksOpen;
    private int hoveredSlot = -1;
    private boolean scrollMode;
    private int scrollSlot = 0;
    private final TagKey<Item> tag;
    private final List<Item> cycle;
    @Nullable
    private final CompoundTag stackTag;

    RadialTagCycleMenu(TagKey<Item> tag, List<Item> cycle, @Nullable CompoundTag stackTag) {
        this.cycle = cycle;
        this.tag = tag;
        this.stackTag = stackTag;
    }

    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        float hoveredY;
        float fade = Mth.clamp((float)(((float)this.ticksOpen + AnimationTickHolder.getPartialTicks()) / 10.0f), (float)0.001953125f, (float)1.0f);
        PoseStack ms = graphics.pose();
        this.hoveredSlot = -1;
        Window window = Minecraft.getInstance().getWindow();
        float hoveredX = mouseX - window.getGuiScaledWidth() / 2;
        float distance = hoveredX * hoveredX + (hoveredY = (float)(mouseY - window.getGuiScaledHeight() / 2)) * hoveredY;
        if (distance > 25.0f && distance < 10000.0f) {
            this.hoveredSlot = Mth.floor((float)(AngleHelper.deg((double)Mth.atan2((double)hoveredY, (double)hoveredX)) + 360.0f + 180.0f - 22.5f)) % 360 / 45;
        }
        if (this.scrollMode && distance > 150.0f) {
            this.scrollMode = false;
        }
        ms.pushPose();
        ms.translate((float)(this.width / 2), (float)(this.height / 2), 0.0f);
        MutableComponent tip = null;
        ResourceLocation tagLoc = this.tag.location();
        MutableComponent title = Component.translatable((String)("tag.item." + tagLoc.getNamespace() + "." + tagLoc.getPath().replace('/', '.')));
        for (int slot = 0; slot < 8; ++slot) {
            boolean selected;
            ms.pushPose();
            double radius = -40.0f + 10.0f * (1.0f - fade) * (1.0f - fade);
            double angle = slot * 45 - 45;
            ((PoseTransformStack)((PoseTransformStack)TransformStack.of((PoseStack)ms).rotateZDegrees((float)angle)).translate(0.0, radius, 0.0)).rotateZDegrees((float)(-angle));
            ms.translate(-12.0f, -12.0f, 0.0f);
            boolean bl = selected = slot == (this.scrollMode ? this.scrollSlot : this.hoveredSlot);
            if (slot < this.cycle.size()) {
                ItemStack stack = new ItemStack((ItemLike)this.cycle.get(slot));
                if (this.stackTag != null) {
                    stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)this.stackTag.copy()));
                }
                if (this.minecraft != null) {
                    AllGuiTextures.TOOLBELT_SLOT.render(graphics, 0, 0);
                    GuiGameElement.of((ItemStack)stack).at(3.0f, 3.0f).render(graphics);
                    if (selected) {
                        AllGuiTextures.TOOLBELT_SLOT_HIGHLIGHT.render(graphics, -1, -1);
                        tip = Component.empty().append(stack.getHoverName()).withStyle(ChatFormatting.GOLD);
                    }
                }
            } else {
                AllGuiTextures.TOOLBELT_EMPTY_SLOT.render(graphics, 0, 0);
            }
            ms.popPose();
        }
        int i1 = (int)(fade * 255.0f);
        if (i1 > 255) {
            i1 = 255;
        }
        if (i1 > 8) {
            ms.pushPose();
            ms.translate(0.0f, -80.0f, 0.0f);
            this.drawComponent(graphics, (Component)title, i1);
        }
        ms.popPose();
        if (tip != null) {
            i1 = (int)(fade * 255.0f);
            if (i1 > 255) {
                i1 = 255;
            }
            if (i1 > 8) {
                ms.pushPose();
                ms.translate((float)(this.width / 2), (float)(this.height - 68), 0.0f);
                this.drawComponent(graphics, (Component)tip, i1);
            }
        }
    }

    private void drawComponent(GuiGraphics graphics, Component title, int i1) {
        PoseStack ms = graphics.pose();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int k1 = 0xFFFFFF;
        int k = i1 << 24 & 0xFF000000;
        int l = this.font.width((FormattedText)title);
        graphics.drawString(this.font, title, -l / 2, -4, k1 | k);
        RenderSystem.disableBlend();
        ms.popPose();
    }

    public void renderBackground(GuiGraphics guiGraphics) {
        int a = (int)(80.0f * Math.min(1.0f, ((float)this.ticksOpen + AnimationTickHolder.getPartialTicks()) / 20.0f)) << 24;
        guiGraphics.fillGradient(0, 0, this.width, this.height, 0x101010 | a, 0x101010 | a);
    }

    public void tick() {
        ++this.ticksOpen;
        super.tick();
    }

    public boolean mouseClicked(double x, double y, int button) {
        int selected;
        int n = selected = this.scrollMode ? this.scrollSlot : this.hoveredSlot;
        if (button == 0 && selected >= 0 && selected < this.cycle.size()) {
            TagCycleHandlerClient.select(this.cycle.get(selected));
            this.onClose();
            BogeyMenuEventsHandler.COOLDOWN = 2;
            TagCycleHandlerClient.COOLDOWN = 2;
            AccessorToolboxHandlerClient.setCOOLDOWN(2);
            return true;
        }
        return super.mouseClicked(x, y, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        double hoveredY;
        Window window = Minecraft.getInstance().getWindow();
        double hoveredX = mouseX - (double)(window.getGuiScaledWidth() / 2);
        double distance = hoveredX * hoveredX + (hoveredY = mouseY - (double)(window.getGuiScaledHeight() / 2)) * hoveredY;
        if (distance <= 150.0) {
            this.scrollMode = true;
            double delta = scrollY;
            this.scrollSlot = ((int)((double)this.scrollSlot - delta) + 8) % 8;
            for (int i = 0; i < 10 && this.scrollSlot >= this.cycle.size(); ++i) {
                this.scrollSlot -= Mth.sign((double)delta);
                this.scrollSlot = (this.scrollSlot + 8) % 8;
            }
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean keyReleased(int code, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.getKey((int)code, (int)scanCode);
        if (ClientUtils.isActiveAndMatches(CRKeys.CYCLE_MENU.getKeybind(), mouseKey)) {
            this.onClose();
            return true;
        }
        return super.keyReleased(code, scanCode, modifiers);
    }
}

