/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_tracks.phantom;

import com.railwayteam.railways.mixin_interfaces.IPotentiallyInvisibleSpriteContents;
import com.railwayteam.railways.registry.CRTags;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;

public abstract class PhantomSpriteManager {
    private static final Map<ResourceLocation, WeakReference<SpriteContents>> map = new ConcurrentHashMap<ResourceLocation, WeakReference<SpriteContents>>();
    private static boolean lastVisible = false;
    public static boolean firstRun = true;
    public static boolean hasChanged = false;
    private static boolean visible = false;

    public static boolean isVisible() {
        return visible;
    }

    public static boolean register(SpriteContents sprite) {
        if (sprite.name().getNamespace().equals("railways") && sprite.name().getPath().startsWith("block/track/phantom/")) {
            map.put(sprite.name(), new WeakReference<SpriteContents>(sprite));
            firstRun = true;
            return true;
        }
        return false;
    }

    public static void tick(Minecraft mc) {
        boolean bl = visible = mc.player != null && (CRTags.AllItemTags.PHANTOM_TRACK_REVEALING.matches(mc.player.getItemBySlot(EquipmentSlot.MAINHAND).getItem()) || CRTags.AllItemTags.PHANTOM_TRACK_REVEALING.matches(mc.player.getItemBySlot(EquipmentSlot.OFFHAND).getItem()));
        if (visible != lastVisible || firstRun) {
            firstRun = false;
            lastVisible = visible;
            hasChanged = true;
            ArrayList<ResourceLocation> expired = new ArrayList<ResourceLocation>();
            for (Map.Entry<ResourceLocation, WeakReference<SpriteContents>> entry : map.entrySet()) {
                if (entry.getValue().get() != null) continue;
                expired.add(entry.getKey());
            }
            for (ResourceLocation key : expired) {
                map.remove(key);
            }
        }
    }

    public static void renderTick() {
        if (hasChanged) {
            hasChanged = false;
            for (WeakReference<SpriteContents> ref : map.values()) {
                SpriteContents sprite = (SpriteContents)ref.get();
                if (sprite == null) continue;
                ((IPotentiallyInvisibleSpriteContents)sprite).railways$uploadFrame(lastVisible);
            }
        }
    }
}

