/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_tracks.generic_crossing.neoforge;

import com.google.common.collect.ImmutableList;
import com.railwayteam.railways.mixin_interfaces.IGenericCrossingTrackBE;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackShape;
import java.util.Collections;
import java.util.List;
import net.createmod.catnip.data.Pair;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
public class GenericCrossingModel
implements BakedModel {
    private final BakedModel wrapped;
    private static final ModelProperty<@Nullable Pair<TrackMaterial, TrackShape>> FIRST_PIECE = new ModelProperty();
    private static final ModelProperty<@Nullable Pair<TrackMaterial, TrackShape>> SECOND_PIECE = new ModelProperty();

    public GenericCrossingModel(BakedModel wrapped) {
        this.wrapped = wrapped;
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IGenericCrossingTrackBE) {
            IGenericCrossingTrackBE genericCrossing = (IGenericCrossingTrackBE)blockEntity;
            return modelData.derive().with(FIRST_PIECE, genericCrossing.railways$getFirstCrossingPiece()).with(SECOND_PIECE, genericCrossing.railways$getSecondCrossingPiece()).build();
        }
        return modelData;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
        Pair second;
        Pair first = (Pair)data.get(FIRST_PIECE);
        if (first != null && (second = (Pair)data.get(SECOND_PIECE)) != null) {
            return ImmutableList.builder().addAll(IGenericCrossingTrackBE.getQuads((Pair<TrackMaterial, TrackShape>)first, side, rand)).addAll(IGenericCrossingTrackBE.getQuads((Pair<TrackMaterial, TrackShape>)second, side, rand)).build();
        }
        return Collections.emptyList();
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction direction, @NotNull RandomSource random) {
        return Collections.emptyList();
    }

    public boolean useAmbientOcclusion() {
        return false;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean usesBlockLight() {
        return true;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.wrapped.getParticleIcon();
    }

    public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
        return this.wrapped.getParticleIcon(data);
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }
}

