/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_tracks.casing;

import com.railwayteam.railways.Railways;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class SpriteCopyingBakedModel
implements BakedModel {
    protected final BakedModel baseModel;
    protected final BakedModel spriteSourceModel;

    public SpriteCopyingBakedModel(BakedModel baseModel, BakedModel spriteSourceModel) {
        this.baseModel = baseModel;
        this.spriteSourceModel = spriteSourceModel;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState pState, @Nullable Direction pSide, RandomSource pRand) {
        List nullQuads;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        TextureAtlasSprite overrideSprite = this.spriteSourceModel.getParticleIcon();
        BakedQuad overrideQuad = null;
        List sourceQuads = this.spriteSourceModel.getQuads(pState, pSide, pRand);
        if (!sourceQuads.isEmpty()) {
            overrideSprite = ((BakedQuad)sourceQuads.get(0)).getSprite();
            overrideQuad = (BakedQuad)sourceQuads.get(0);
        } else if (pSide != null && !(nullQuads = this.spriteSourceModel.getQuads(pState, null, pRand)).isEmpty()) {
            overrideSprite = ((BakedQuad)nullQuads.get(0)).getSprite();
            overrideQuad = (BakedQuad)nullQuads.get(0);
        }
        for (BakedQuad quad : this.baseModel.getQuads(pState, pSide, pRand)) {
            if (overrideSprite == null || overrideQuad == null) {
                Railways.LOGGER.error("No overriding sprites found for side " + (pSide == null ? "null" : pSide.toString()) + " blockstate: " + (pState == null ? "null" : pState.toString()));
            }
            quads.add(new BakedQuad(this.transformVertices(quad.getVertices(), quad.getSprite(), overrideQuad != null ? overrideQuad : quad), quad.getTintIndex(), quad.getDirection(), overrideSprite != null ? overrideSprite : quad.getSprite(), true));
        }
        return quads;
    }

    private int[] transformVertices(int[] baseVertices, TextureAtlasSprite baseSprite, BakedQuad uvSource) {
        TextureAtlasSprite goalSprite = uvSource.getSprite();
        int[] newVertices = (int[])baseVertices.clone();
        for (int i = 0; i < baseVertices.length; i += 8) {
            newVertices[i + 4] = Float.floatToRawIntBits(Float.intBitsToFloat(baseVertices[i + 4]) - baseSprite.getU0() + goalSprite.getU0());
            newVertices[i + 5] = Float.floatToRawIntBits(Float.intBitsToFloat(baseVertices[i + 5]) - baseSprite.getV0() + goalSprite.getV0());
        }
        return newVertices;
    }

    public boolean useAmbientOcclusion() {
        return this.spriteSourceModel.useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.spriteSourceModel.isGui3d();
    }

    public boolean usesBlockLight() {
        return this.spriteSourceModel.usesBlockLight();
    }

    public boolean isCustomRenderer() {
        return this.baseModel.isCustomRenderer();
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.spriteSourceModel.getParticleIcon();
    }

    public ItemTransforms getTransforms() {
        return ItemTransforms.NO_TRANSFORMS;
    }

    public ItemOverrides getOverrides() {
        return this.baseModel.getOverrides();
    }
}

