/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_tracks.casing;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.mixin_interfaces.IHasTrackCasing;
import com.railwayteam.railways.multiloader.C2SPacket;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.railwayteam.railways.util.AdventureUtils;
import com.railwayteam.railways.util.EntityUtils;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SlabUseOnCurvePacket
implements C2SPacket {
    private BlockPos pos;
    private BlockPos targetPos;
    private BlockPos soundSource;

    public SlabUseOnCurvePacket(BlockPos pos, BlockPos targetPos, BlockPos soundSource) {
        this.pos = pos;
        this.targetPos = targetPos;
        this.soundSource = soundSource;
    }

    public SlabUseOnCurvePacket(FriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.targetPos = buffer.readBlockPos();
        this.soundSource = buffer.readBlockPos();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeBlockPos(this.targetPos);
        buffer.writeBlockPos(this.soundSource);
    }

    @Override
    public void handle(ServerPlayer player) {
        Level world = player.level();
        if (AdventureUtils.isAdventure((Player)player)) {
            return;
        }
        if (!world.isLoaded(this.pos)) {
            return;
        }
        if (!this.pos.closerThan((Vec3i)player.blockPosition(), 64.0)) {
            return;
        }
        BlockEntity BlockEntity2 = world.getBlockEntity(this.pos);
        if (BlockEntity2 instanceof TrackBlockEntity) {
            TrackBlockEntity track = (TrackBlockEntity)BlockEntity2;
            this.applySettings(player, track);
            track.notifyUpdate();
        }
    }

    private InteractionResult useOn(ServerPlayer player, InteractionHand hand, Level world, IHasTrackCasing casingAble) {
        SlabBlock currentCasing;
        BlockItem blockItem;
        if (world.isClientSide) {
            return InteractionResult.FAIL;
        }
        ItemStack handStack = player.getItemInHand(hand);
        Item item = handStack.getItem();
        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof SlabBlock) {
            SlabBlock slabBlock = (SlabBlock)item;
            currentCasing = casingAble.getTrackCasing();
            if (currentCasing == slabBlock) {
                casingAble.setAlternate(!casingAble.isAlternate());
                return InteractionResult.SUCCESS;
            }
            if (!player.isCreative()) {
                handStack.shrink(1);
                if (currentCasing != null) {
                    ItemStack casingStack = new ItemStack((ItemLike)currentCasing);
                    EntityUtils.givePlayerItem((Player)player, casingStack);
                }
                player.setItemInHand(hand, handStack);
            }
            casingAble.setTrackCasing(slabBlock);
            return InteractionResult.SUCCESS;
        }
        if (handStack.isEmpty() && (currentCasing = casingAble.getTrackCasing()) != null) {
            handStack = new ItemStack((ItemLike)currentCasing);
            casingAble.setTrackCasing(null);
            if (!player.isCreative()) {
                EntityUtils.givePlayerItem((Player)player, handStack);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void applySettings(ServerPlayer player, TrackBlockEntity te) {
        if (!te.getBlockPos().closerThan((Vec3i)player.blockPosition(), 128.0)) {
            Railways.LOGGER.warn(player.getScoreboardName() + " too far away from slabbed Curve track");
            return;
        }
        Level level = te.getLevel();
        BezierConnection bezierConnection = (BezierConnection)te.getConnections().get(this.targetPos);
        if (bezierConnection.getMaterial().trackType == CRTrackMaterials.CRTrackType.MONORAIL) {
            Railways.LOGGER.warn(player.getScoreboardName() + "tried to slab a monorail track");
            return;
        }
        if (level != null) {
            InteractionHand hand = InteractionHand.MAIN_HAND;
            InteractionResult result = this.useOn(player, hand, level, (IHasTrackCasing)bezierConnection);
            if (!result.consumesAction()) {
                hand = InteractionHand.OFF_HAND;
                result = this.useOn(player, hand, level, (IHasTrackCasing)bezierConnection);
            }
            if (result.shouldSwing()) {
                player.swing(hand, true);
            }
            te.notifyUpdate();
        }
    }
}

