/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.coupling.coupler;

import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.content.coupling.coupler.TrackCoupler;
import com.railwayteam.railways.content.coupling.coupler.TrackCouplerBlockEntity;
import com.railwayteam.railways.mixin.AccessorTrackTargetingBehavior;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.railwayteam.railways.util.CustomTrackOverlayRendering;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackTargetingBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TrackCouplerRenderer
extends SmartBlockEntityRenderer<TrackCouplerBlockEntity> {
    public TrackCouplerRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Nullable
    public static PartialModel getCouplerOverlayModel(TrackCouplerBlockEntity te) {
        if (te.areEdgePointsOk()) {
            TrackCouplerBlockEntity.AllowedOperationMode mode = te.getAllowedOperationMode();
            if (mode.canCouple && mode.canDecouple) {
                return CRBlockPartials.COUPLER_BOTH;
            }
            if (mode.canCouple) {
                return CRBlockPartials.COUPLER_COUPLE;
            }
            if (mode.canDecouple) {
                return CRBlockPartials.COUPLER_DECOUPLE;
            }
        } else {
            return CRBlockPartials.COUPLER_NONE;
        }
        return null;
    }

    protected void renderSafe(TrackCouplerBlockEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((SmartBlockEntity)te, partialTicks, ms, buffer, light, overlay);
        this.renderEdgePoint(te, ms, buffer, light, overlay, te.edgePoint);
        this.renderEdgePoint(te, ms, buffer, light, overlay, te.secondEdgePoint);
    }

    private void renderEdgePoint(TrackCouplerBlockEntity te, PoseStack ms, MultiBufferSource buffer, int light, int overlay, TrackTargetingBehaviour<TrackCoupler> target) {
        BlockPos pos = te.getBlockPos();
        boolean offsetToSide = CustomTrackOverlayRendering.overlayWillOverlap(target);
        BlockPos targetPosition = target.getGlobalPosition();
        Direction.AxisDirection targetDirection = target.getTargetDirection();
        Level level = te.getLevel();
        BlockState trackState = level.getBlockState(targetPosition);
        Block block = trackState.getBlock();
        if (!(block instanceof ITrackBlock)) {
            boolean found = false;
            try {
                BlockPos rawTarget = ((AccessorTrackTargetingBehavior)target).getTargetTrack();
                BlockState tryState = level.getBlockState(rawTarget);
                if (tryState.getBlock() instanceof ITrackBlock) {
                    trackState = tryState;
                    targetPosition = rawTarget;
                    block = tryState.getBlock();
                    found = true;
                } else {
                    BlockPos worldPos = pos.offset((Vec3i)rawTarget);
                    tryState = level.getBlockState(worldPos);
                    if (tryState.getBlock() instanceof ITrackBlock) {
                        trackState = tryState;
                        targetPosition = worldPos;
                        block = tryState.getBlock();
                        found = true;
                    }
                }
                if (!found) {
                    return;
                }
            }
            catch (Exception ignored) {
                return;
            }
        }
        ms.pushPose();
        TransformStack.of((PoseStack)ms).translate((Vec3i)targetPosition.subtract((Vec3i)pos));
        CustomTrackOverlayRendering.renderOverlay((LevelAccessor)level, targetPosition, targetDirection, target.getTargetBezier(), ms, buffer, light, overlay, TrackCouplerRenderer.getCouplerOverlayModel(te), 1.0f, offsetToSide);
        ms.popPose();
    }
}

