/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor;

import com.railwayteam.railways.compat.Mods;
import com.railwayteam.railways.compat.tweakeroo.TweakerooCompat;
import com.railwayteam.railways.content.conductor.ClientHandler;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.mixin.client.AccessorLocalPlayer;
import com.railwayteam.railways.mixin.conductor_possession.AccessorClientChunkCacheStorage;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.util.packet.CameraMovePacket;
import com.railwayteam.railways.util.packet.DismountCameraPacket;
import com.railwayteam.railways.util.packet.SpyConductorInteractPacket;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerInputPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class ConductorPossessionController {
    @OnlyIn(value=Dist.CLIENT)
    private static Object cameraStorage;
    private static boolean wasUpPressed;
    private static boolean wasDownPressed;
    private static boolean wasLeftPressed;
    private static boolean wasRightPressed;
    private static boolean wasJumpPressed;
    private static boolean wasSprintPressed;
    private static boolean wasMounted;
    private static final boolean[] wasMouseClicked;
    private static final boolean[] wasMousePressed;
    private static boolean wasUsingBefore;
    private static int ticksSincePacket;
    private static int positionReminder;

    @OnlyIn(value=Dist.CLIENT)
    public static void onClientTick(Minecraft mc, boolean start) {
        Entity cameraEntity = mc.cameraEntity;
        if (cameraEntity instanceof ConductorEntity) {
            ConductorEntity cam = (ConductorEntity)cameraEntity;
            wasMounted = true;
            Options options = mc.options;
            if (start) {
                wasUpPressed = options.keyUp.isDown();
                if (wasUpPressed) {
                    options.keyUp.setDown(false);
                }
                if (wasDownPressed = options.keyDown.isDown()) {
                    options.keyDown.setDown(false);
                }
                if (wasLeftPressed = options.keyLeft.isDown()) {
                    options.keyLeft.setDown(false);
                }
                if (wasRightPressed = options.keyRight.isDown()) {
                    options.keyRight.setDown(false);
                }
                if (wasJumpPressed = options.keyJump.isDown()) {
                    options.keyJump.setDown(false);
                }
                wasSprintPressed = options.keySprint.isDown();
                if (options.keyShift.isDown()) {
                    ConductorPossessionController.dismount();
                    options.keyShift.setDown(false);
                }
            } else {
                boolean bl5;
                if (wasUpPressed) {
                    options.keyUp.setDown(true);
                }
                if (wasDownPressed) {
                    options.keyDown.setDown(true);
                }
                if (wasLeftPressed) {
                    options.keyLeft.setDown(true);
                }
                if (wasRightPressed) {
                    options.keyRight.setDown(true);
                }
                if (wasJumpPressed) {
                    options.keyJump.setDown(true);
                }
                LocalPlayer player = mc.player;
                double yRotChange = player.getYRot() - ((AccessorLocalPlayer)player).railways$getYRotLast();
                double xRotChange = player.getXRot() - ((AccessorLocalPlayer)player).railways$getXRotLast();
                if (yRotChange != 0.0 || xRotChange != 0.0 || ++ticksSincePacket > 10) {
                    ticksSincePacket = 0;
                    player.connection.send((Packet)new ServerboundMovePlayerPacket.Rot(player.getYRot(), player.getXRot(), player.onGround()));
                    player.connection.send((Packet)new ServerboundPlayerInputPacket(0.0f, 0.0f, false, false));
                }
                double d = cam.getX() - cam.xLast;
                double e = cam.getY() - cam.yLast;
                double f = cam.getZ() - cam.zLast;
                double g = (double)cam.getYRot() - cam.yRotLast;
                double h = (double)cam.getXRot() - cam.xRotLast;
                boolean bl3 = Mth.lengthSquared((double)d, (double)e, (double)f) > Mth.square((double)2.0E-4) || ++positionReminder >= 20;
                boolean bl = bl5 = g != 0.0 || h != 0.0;
                if (bl3 || bl5) {
                    CRPackets.PACKETS.send(new CameraMovePacket(cam, new ServerboundMovePlayerPacket.PosRot(cam.getX(), cam.getY(), cam.getZ(), cam.getYRot(), cam.getXRot(), cam.onGround())));
                }
            }
        } else if (wasMounted && !Mods.TWEAKEROO.runIfInstalled(() -> TweakerooCompat::inFreecam).orElse(false).booleanValue()) {
            wasMounted = false;
            ConductorPossessionController.dismount();
            mc.levelRenderer.allChanged();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onHandleKeybinds(Minecraft mc, boolean start) {
        Entity cameraEntity = mc.cameraEntity;
        if (cameraEntity instanceof ConductorEntity) {
            ConductorEntity cam = (ConductorEntity)cameraEntity;
            wasMounted = true;
            Options options = mc.options;
            if (start) {
                Arrays.fill(wasMouseClicked, false);
                Arrays.fill(wasMousePressed, false);
                while (options.keyAttack.consumeClick()) {
                    ConductorPossessionController.wasMouseClicked[0] = true;
                }
                while (options.keyUse.consumeClick()) {
                    ConductorPossessionController.wasMouseClicked[1] = true;
                }
                while (options.keyPickItem.consumeClick()) {
                    ConductorPossessionController.wasMouseClicked[2] = true;
                }
                ConductorPossessionController.wasMousePressed[0] = options.keyAttack.isDown();
                if (ConductorPossessionController.wasMousePressed[0]) {
                    options.keyAttack.setDown(false);
                }
                if (ConductorPossessionController.wasMousePressed[1] = options.keyUse.isDown()) {
                    options.keyUse.setDown(false);
                }
                if (ConductorPossessionController.wasMousePressed[2] = options.keyPickItem.isDown()) {
                    options.keyPickItem.setDown(false);
                }
            } else {
                if (wasMousePressed[0]) {
                    options.keyAttack.setDown(true);
                }
                if (wasMousePressed[1]) {
                    options.keyUse.setDown(true);
                    if (!wasUsingBefore) {
                        BlockHitResult blockHitResult;
                        wasUsingBefore = true;
                        HitResult hitresult = mc.hitResult;
                        if (hitresult != null && hitresult.getType() == HitResult.Type.BLOCK && mc.level != null && hitresult instanceof BlockHitResult && ConductorEntity.canSpyInteract(mc.level.getBlockState((blockHitResult = (BlockHitResult)hitresult).getBlockPos()))) {
                            CRPackets.PACKETS.send(new SpyConductorInteractPacket(blockHitResult.getBlockPos()));
                        }
                    }
                } else {
                    wasUsingBefore = false;
                }
                if (wasMousePressed[2]) {
                    options.keyPickItem.setDown(true);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @ApiStatus.Internal
    public static void dismount() {
        CRPackets.PACKETS.send(new DismountCameraPacket());
        wasMounted = false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Object getCameraStorage() {
        return cameraStorage;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setCameraStorage(Object newStorage) {
        cameraStorage = newStorage;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setRenderPosition(Entity entity) {
        if (entity instanceof ConductorEntity) {
            Object object;
            SectionPos cameraPos = SectionPos.of((EntityAccess)entity);
            if (cameraStorage != null && (object = cameraStorage) instanceof AccessorClientChunkCacheStorage) {
                AccessorClientChunkCacheStorage storage = (AccessorClientChunkCacheStorage)object;
                storage.railways$setViewCenterX(cameraPos.x());
                storage.railways$setViewCenterZ(cameraPos.z());
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void tryUpdatePossession(ConductorEntity conductorEntity) {
        if (ClientHandler.getPlayerMountedOnCamera() == conductorEntity) {
            ConductorPossessionController.setRenderPosition((Entity)conductorEntity);
        }
    }

    public static boolean isPossessingConductor(Entity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        if (player.level().isClientSide) {
            return ClientHandler.isPlayerMountedOnCamera();
        }
        return ((ServerPlayer)player).getCamera() instanceof ConductorEntity;
    }

    @Nullable
    public static ConductorEntity getPossessingConductor(Entity entity) {
        ConductorEntity ce;
        if (!(entity instanceof Player)) {
            return null;
        }
        Player player = (Player)entity;
        if (player.level().isClientSide) {
            return ClientHandler.getPlayerMountedOnCamera();
        }
        Entity entity2 = ((ServerPlayer)player).getCamera();
        return entity2 instanceof ConductorEntity ? (ce = (ConductorEntity)entity2) : null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean wasUpPressed() {
        return wasUpPressed;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean wasDownPressed() {
        return wasDownPressed;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean wasLeftPressed() {
        return wasLeftPressed;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean wasRightPressed() {
        return wasRightPressed;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean wasSprintPressed() {
        return wasSprintPressed;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean wasJumpPressed() {
        return wasJumpPressed;
    }

    static {
        wasMouseClicked = new boolean[3];
        wasMousePressed = new boolean[3];
        ticksSincePacket = 0;
        positionReminder = 0;
    }
}

