/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.buffer.headstock;

import com.mojang.serialization.MapCodec;
import com.railwayteam.railways.content.buffer.BlockStateBlockItemGroup;
import com.railwayteam.railways.content.buffer.headstock.HeadstockBlockEntity;
import com.railwayteam.railways.content.buffer.headstock.HeadstockStyle;
import com.railwayteam.railways.registry.CRBlockEntities;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.registry.CRShapes;
import com.railwayteam.railways.util.AdventureUtils;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class HeadstockBlock
extends HorizontalDirectionalBlock
implements IBE<HeadstockBlockEntity>,
IWrenchable,
ProperWaterloggedBlock,
BlockStateBlockItemGroup.GroupedBlock {
    public static final MapCodec<HeadstockBlock> CODEC = HeadstockBlock.simpleCodec(HeadstockBlock::new);
    public static final EnumProperty<HeadstockStyle> STYLE = EnumProperty.create((String)"style", HeadstockStyle.class);
    public static final BooleanProperty UPSIDE_DOWN = BooleanProperty.create((String)"upside_down");

    public HeadstockBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(STYLE, (Comparable)((Object)HeadstockStyle.BUFFER))).setValue((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends HeadstockBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{FACING, WATERLOGGED, STYLE, UPSIDE_DOWN}));
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        IBE.onRemove((BlockState)state, (Level)worldIn, (BlockPos)pos, (BlockState)newState);
    }

    public FluidState getFluidState(BlockState state) {
        return this.fluidState(state);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state != null) {
            if (context.getClickedFace().getAxis().isVertical()) {
                state = (BlockState)state.setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
            } else {
                state = (BlockState)state.setValue((Property)FACING, (Comparable)context.getClickedFace());
                if (context.getClickLocation().y - (double)context.getClickedPos().getY() < 0.5) {
                    state = (BlockState)state.setValue((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(true));
                }
            }
        }
        return this.withWater(state, context);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        VoxelShape shape = (switch ((HeadstockStyle)((Object)state.getValue(STYLE))) {
            default -> throw new MatchException(null, null);
            case HeadstockStyle.PLAIN -> CRShapes.HEADSTOCK_PLAIN;
            case HeadstockStyle.BUFFER -> CRShapes.HEADSTOCK_BUFFER;
            case HeadstockStyle.LINK, HeadstockStyle.LINKLESS -> CRShapes.HEADSTOCK_LINK_PIN;
            case HeadstockStyle.KNUCKLE, HeadstockStyle.KNUCKLE_SPLIT -> CRShapes.HEADSTOCK_KNUCKLE;
            case HeadstockStyle.SCREWLINK -> CRShapes.HEADSTOCK_SCREWLINK;
        }).get(dir);
        if (((Boolean)state.getValue((Property)UPSIDE_DOWN)).booleanValue()) {
            AABB toErase = (AABB)CRShapes.HEADSTOCK_PLAIN.get(dir).toAabbs().get(0);
            return new AllShapes.Builder(shape).erase(toErase.minX * 16.0, toErase.minY * 16.0, toErase.minZ * 16.0, toErase.maxX * 16.0, toErase.maxY * 16.0, toErase.maxZ * 16.0).add(CRShapes.HEADSTOCK_PLAIN.get(dir).move(0.0, -0.25, 0.0)).build();
        }
        return shape;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        this.updateWater(level, state, currentPos);
        return state;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (AdventureUtils.isAdventure(pPlayer)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        InteractionResult result = this.onBlockEntityUse((BlockGetter)pLevel, pPos, be -> be.applyMaterialIfValid(stack));
        if (result.consumesAction()) {
            return ItemInteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
        }
        result = this.onBlockEntityUse((BlockGetter)pLevel, pPos, be -> be.applyDyeIfValid(stack));
        return result.consumesAction() ? ItemInteractionResult.sidedSuccess((boolean)pLevel.isClientSide) : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public Class<HeadstockBlockEntity> getBlockEntityClass() {
        return HeadstockBlockEntity.class;
    }

    public BlockEntityType<? extends HeadstockBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CRBlockEntities.HEADSTOCK.get();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return CRBlocks.HEADSTOCK_GROUP.get((HeadstockStyle)((Object)state.getValue(STYLE))).asStack();
    }
}

