/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.buffer.headstock;

import com.railwayteam.railways.content.buffer.BlockStateBlockItemGroup;
import com.railwayteam.railways.content.buffer.headstock.CopycatHeadstockBlockEntity;
import com.railwayteam.railways.content.buffer.headstock.HeadstockBlock;
import com.railwayteam.railways.content.buffer.headstock.HeadstockStyle;
import com.railwayteam.railways.registry.CRBlockEntities;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.registry.CRShapes;
import com.railwayteam.railways.util.AdventureUtils;
import com.railwayteam.railways.util.client.OcclusionTestLevel;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.decoration.copycat.CopycatBlockEntity;
import com.simibubi.create.content.decoration.copycat.CopycatSpecialCases;
import com.simibubi.create.content.decoration.copycat.WaterloggedCopycatBlock;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CopycatHeadstockBlock
extends WaterloggedCopycatBlock
implements BlockStateBlockItemGroup.GroupedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<HeadstockStyle> STYLE = HeadstockBlock.STYLE;
    public static final BooleanProperty UPSIDE_DOWN = HeadstockBlock.UPSIDE_DOWN;

    public CopycatHeadstockBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(STYLE, (Comparable)((Object)HeadstockStyle.BUFFER))).setValue((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{FACING, STYLE, UPSIDE_DOWN}));
    }

    public boolean isAcceptedRegardless(BlockState material) {
        return CopycatSpecialCases.isBarsMaterial((BlockState)material);
    }

    public boolean isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState state, Direction face, BlockPos fromPos, BlockPos toPos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockState toState = reader.getBlockState(toPos);
        BlockPos diff = fromPos.subtract((Vec3i)toPos);
        int coord = facing.getAxis().choose(diff.getX(), diff.getY(), diff.getZ());
        if (!(toState.getBlock() instanceof CopycatHeadstockBlock)) {
            return facing != face.getOpposite();
        }
        return facing == ((Direction)toState.getValue((Property)FACING)).getOpposite() && (coord == 0 || coord != facing.getAxisDirection().getStep());
    }

    public boolean canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockState toState = reader.getBlockState(toPos);
        if (toPos.equals((Object)fromPos.relative(facing))) {
            return false;
        }
        BlockPos diff = fromPos.subtract((Vec3i)toPos);
        int coord = facing.getAxis().choose(diff.getX(), diff.getY(), diff.getZ());
        if (!(toState.getBlock() instanceof CopycatHeadstockBlock)) {
            return coord != -facing.getAxisDirection().getStep();
        }
        if (CopycatHeadstockBlock.isOccluded(state, toState, facing.getOpposite())) {
            return true;
        }
        return toState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)) == state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)) && coord == 0;
    }

    public boolean canFaceBeOccluded(BlockState state, Direction face) {
        return ((Direction)state.getValue((Property)FACING)).getOpposite() == face;
    }

    public boolean shouldFaceAlwaysRender(BlockState state, Direction face) {
        if (state.getValue((Property)FACING) == face) {
            return true;
        }
        return face.getAxis().isVertical() && face == Direction.DOWN ^ (Boolean)state.getValue((Property)UPSIDE_DOWN);
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        pos = pos.immutable();
        BlockPos otherPos = pos.relative(dir);
        BlockState material = CopycatHeadstockBlock.getMaterial((BlockGetter)level, (BlockPos)pos);
        BlockState otherMaterial = CopycatHeadstockBlock.getMaterial((BlockGetter)level, (BlockPos)otherPos);
        if (material == null) {
            material = AllBlocks.COPYCAT_BASE.getDefaultState();
        }
        if (otherMaterial == null) {
            otherMaterial = AllBlocks.COPYCAT_BASE.getDefaultState();
        }
        if (state.is((Block)this) == neighborState.is((Block)this)) {
            if (CopycatSpecialCases.isBarsMaterial((BlockState)material) && CopycatSpecialCases.isBarsMaterial((BlockState)otherMaterial)) {
                return state.getValue((Property)FACING) == neighborState.getValue((Property)FACING) && state.getValue((Property)UPSIDE_DOWN) == neighborState.getValue((Property)UPSIDE_DOWN);
            }
            if (material.skipRendering(otherMaterial, dir.getOpposite())) {
                return CopycatHeadstockBlock.isOccluded(state, neighborState, dir.getOpposite());
            }
            OcclusionTestLevel occlusionTestLevel = new OcclusionTestLevel(level);
            occlusionTestLevel.setBlock(pos, material);
            occlusionTestLevel.setBlock(otherPos, otherMaterial);
            if (material.isSolidRender((BlockGetter)occlusionTestLevel, pos) && otherMaterial.isSolidRender((BlockGetter)occlusionTestLevel, otherPos) && !Block.shouldRenderFace((BlockState)otherMaterial, (BlockGetter)occlusionTestLevel, (BlockPos)pos, (Direction)dir.getOpposite(), (BlockPos)otherPos)) {
                occlusionTestLevel.clear();
                return CopycatHeadstockBlock.isOccluded(state, neighborState, dir.getOpposite());
            }
            occlusionTestLevel.clear();
        }
        return state.getValue((Property)FACING) == dir.getOpposite() && material.skipRendering(neighborState, dir.getOpposite());
    }

    private static boolean isOccluded(BlockState state, BlockState other, Direction pDirection) {
        state = (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        other = (BlockState)other.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (facing.getOpposite() == other.getValue((Property)FACING) && pDirection == facing) {
            return true;
        }
        if (other.getValue((Property)FACING) != facing) {
            return false;
        }
        if (other.getValue((Property)UPSIDE_DOWN) != state.getValue((Property)UPSIDE_DOWN)) {
            return false;
        }
        return pDirection.getAxis() != facing.getAxis() && pDirection.getAxis().isHorizontal();
    }

    public BlockEntityType<? extends CopycatBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CRBlockEntities.COPYCAT_HEADSTOCK.get();
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return this.rotate(state, mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        InteractionResult result = super.onWrenched(state, context);
        if (result.consumesAction()) {
            return result;
        }
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        if (world instanceof ServerLevel) {
            if (player != null && !player.isCreative()) {
                Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.getBlockEntity(pos), (Entity)player, (ItemStack)context.getItemInHand()).forEach(itemStack -> player.getInventory().placeItemBackInInventory(itemStack));
            }
            state.spawnAfterBreak((ServerLevel)world, pos, ItemStack.EMPTY, true);
            world.destroyBlock(pos, false);
            IWrenchable.playRemoveSound((Level)world, (BlockPos)pos);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        InteractionResult result = this.IWrenchable$onWrenched(state, context);
        if (result.consumesAction()) {
            return result;
        }
        return super.onWrenched(state, context);
    }

    private InteractionResult IWrenchable$onWrenched(BlockState state, UseOnContext context) {
        Level world = context.getLevel();
        BlockState rotated = this.getRotatedBlockState(state, context.getClickedFace());
        if (rotated == state) {
            return InteractionResult.PASS;
        }
        if (!rotated.canSurvive((LevelReader)world, context.getClickedPos())) {
            return InteractionResult.PASS;
        }
        KineticBlockEntity.switchToBlockState((Level)world, (BlockPos)context.getClickedPos(), (BlockState)this.updateAfterWrenched(rotated, context));
        BlockEntity be = context.getLevel().getBlockEntity(context.getClickedPos());
        if (be instanceof GeneratingKineticBlockEntity) {
            ((GeneratingKineticBlockEntity)be).reActivateSource = true;
        }
        if (world.getBlockState(context.getClickedPos()) != state) {
            IWrenchable.playRotateSound((Level)world, (BlockPos)context.getClickedPos());
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state != null) {
            if (context.getClickedFace().getAxis().isVertical()) {
                state = (BlockState)state.setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
            } else {
                state = (BlockState)state.setValue((Property)FACING, (Comparable)context.getClickedFace());
                if (context.getClickLocation().y - (double)context.getClickedPos().getY() < 0.5) {
                    state = (BlockState)state.setValue((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(true));
                }
            }
        }
        return state;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ((HeadstockBlock)CRBlocks.HEADSTOCK.get()).getShape(state, level, pos, context);
    }

    protected VoxelShape getHeadstockShape(BlockState state) {
        return CRShapes.HEADSTOCK_PLAIN.get((Direction)state.getValue((Property)FACING));
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (AdventureUtils.isAdventure(pPlayer)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        InteractionResult result = this.onBlockEntityUse((BlockGetter)pLevel, pPos, be -> {
            if (be instanceof CopycatHeadstockBlockEntity) {
                CopycatHeadstockBlockEntity copycatHeadstock = (CopycatHeadstockBlockEntity)be;
                return copycatHeadstock.applyDyeIfValid(pPlayer.getItemInHand(pHand));
            }
            return InteractionResult.PASS;
        });
        if (result.consumesAction()) {
            return ItemInteractionResult.SUCCESS;
        }
        ItemInteractionResult superResult = super.useItemOn(pStack, pState, pLevel, pPos, pPlayer, pHand, pHit);
        return superResult;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ItemColor wrappedItemColor() {
        return new WrappedItemColor();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return CRBlocks.COPYCAT_HEADSTOCK_GROUP.get((HeadstockStyle)((Object)state.getValue(STYLE))).asStack();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class WrappedItemColor
    implements ItemColor {
        public int getColor(ItemStack itemStack, int i) {
            return GrassColor.get((double)0.5, (double)1.0);
        }
    }
}

