/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.compat.tracks.neoforge;

import com.railwayteam.railways.compat.tracks.CompatTrackBlockStateGenerator;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackShape;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;

public class CompatTrackBlockStateGeneratorImpl
extends CompatTrackBlockStateGenerator {
    public <T extends Block> ModelFile getModel(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov, BlockState state) {
        TrackShape value = (TrackShape)state.getValue((Property)TrackBlock.SHAPE);
        TrackMaterial material = ((TrackBlock)ctx.getEntry()).getMaterial();
        if (value == TrackShape.NONE) {
            return prov.models().getExistingFile(prov.mcLoc("block/air"));
        }
        String prefix = "block/track/" + material.resourceName() + "/";
        String outputPrefix = "block/track/compat/" + material.id.getNamespace() + "/" + material.resourceName() + "/";
        HashMap<String, String> textureMap = new HashMap<String, String>();
        switch (value) {
            case TE: 
            case TN: 
            case TS: 
            case TW: {
                textureMap.put("1", "portal_track_");
                textureMap.put("2", "portal_track_mip_");
                textureMap.put("3", "standard_track_");
                break;
            }
            case AE: 
            case AW: 
            case AN: 
            case AS: {
                textureMap.put("0", "standard_track_");
                textureMap.put("1", "standard_track_mip_");
                break;
            }
            case CR_O: 
            case XO: 
            case ZO: {
                textureMap.put("1", "standard_track_");
                textureMap.put("2", "standard_track_mip_");
                textureMap.put("3", "standard_track_crossing_");
                break;
            }
            default: {
                textureMap.put("0", "standard_track_");
                textureMap.put("1", "standard_track_mip_");
                textureMap.put("2", "standard_track_crossing_");
            }
        }
        BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(outputPrefix + value.getModel(), Create.asResource((String)("block/track/" + value.getModel())))).texture("particle", material.particle);
        for (String k : textureMap.keySet()) {
            builder = (BlockModelBuilder)builder.texture(k, ResourceLocation.fromNamespaceAndPath((String)material.id.getNamespace(), (String)(prefix + (String)textureMap.get(k) + material.resourceName())));
        }
        for (String k : new String[]{"segment_left", "segment_right", "tie"}) {
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(outputPrefix + k, Create.asResource((String)("block/track/" + k)))).texture("0", ResourceLocation.fromNamespaceAndPath((String)material.id.getNamespace(), (String)(prefix + "standard_track_" + material.resourceName())))).texture("1", ResourceLocation.fromNamespaceAndPath((String)material.id.getNamespace(), (String)(prefix + "standard_track_mip_" + material.resourceName())))).texture("particle", material.particle);
        }
        return builder;
    }

    public static CompatTrackBlockStateGenerator create() {
        return new CompatTrackBlockStateGeneratorImpl();
    }
}

