/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.compat.create;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.MountedStorageSyncPacket;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;

public final class MountedStorageSyncDeferral {
    private static final int TTL_TICKS = 200;
    private static final Map<Integer, Pending> PENDING_BY_ENTITY = new LinkedHashMap<Integer, Pending>();

    private MountedStorageSyncDeferral() {
    }

    public static void defer(MountedStorageSyncPacket packet) {
        PENDING_BY_ENTITY.put(packet.contraptionId(), new Pending(packet, 200));
    }

    public static void clientTick(Minecraft mc) {
        if (PENDING_BY_ENTITY.isEmpty()) {
            return;
        }
        if (mc.level == null) {
            return;
        }
        Iterator<Map.Entry<Integer, Pending>> iterator = PENDING_BY_ENTITY.entrySet().iterator();
        while (iterator.hasNext()) {
            AbstractContraptionEntity ace;
            Map.Entry<Integer, Pending> entry = iterator.next();
            Pending pending = entry.getValue();
            Entity entity = mc.level.getEntity(entry.getKey().intValue());
            if (entity instanceof AbstractContraptionEntity && (ace = (AbstractContraptionEntity)entity).getContraption() != null) {
                ace.getContraption().getStorage().handleSync(pending.packet, ace);
                iterator.remove();
                continue;
            }
            --pending.ticksRemaining;
            if (pending.ticksRemaining > 0) continue;
            iterator.remove();
        }
    }

    private static final class Pending {
        private final MountedStorageSyncPacket packet;
        private int ticksRemaining;

        private Pending(MountedStorageSyncPacket packet, int ticksRemaining) {
            this.packet = packet;
            this.ticksRemaining = ticksRemaining;
        }
    }
}

