/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.base.datafixers;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import net.minecraft.util.datafix.fixes.References;

public class CompatCherryTrackFix
extends DataFix {
    public static final ImmutableList<String> standardCherryOld = ImmutableList.of((Object)"railways:track_biomesoplenty_cherry", (Object)"railways:track_byg_cherry", (Object)"railways:track_blue_skies_cherry");
    public static final ImmutableList<String> wideCherryOld = ImmutableList.of((Object)"railways:track_biomesoplenty_cherry_wide", (Object)"railways:track_byg_cherry_wide", (Object)"railways:track_blue_skies_cherry_wide");
    public static final ImmutableList<String> narrowCherryOld = ImmutableList.of((Object)"railways:track_biomesoplenty_cherry_narrow", (Object)"railways:track_byg_cherry_narrow", (Object)"railways:track_blue_skies_cherry_narrow");
    private final String name;

    public CompatCherryTrackFix(Schema outputSchema, String name) {
        super(outputSchema, false);
        this.name = name;
    }

    protected TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped(this.name + " for block_state", this.getInputSchema().getType(References.BLOCK_STATE), typed -> typed.update(DSL.remainderFinder(), dynamic -> {
            Optional optional = dynamic.get("Name").asString().result();
            if (optional.isPresent()) {
                if (standardCherryOld.contains(optional.get())) {
                    return CompatCherryTrackFix.fixCherryData(dynamic, "railways:track_cherry");
                }
                if (wideCherryOld.contains(optional.get())) {
                    return CompatCherryTrackFix.fixCherryData(dynamic, "railways:track_cherry_wide");
                }
                if (narrowCherryOld.contains(optional.get())) {
                    return CompatCherryTrackFix.fixCherryData(dynamic, "railways:track_cherry_narrow");
                }
            }
            return dynamic;
        }));
    }

    private static Dynamic<?> fixCherryData(Dynamic<?> dynamic, String name) {
        dynamic = dynamic.set("Name", dynamic.createString(name));
        return dynamic.set("Properties", dynamic.get("Properties").orElseEmptyMap());
    }
}

