/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.base.data.recipe;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.base.data.recipe.RailwaysRecipeProvider;
import com.railwayteam.railways.base.data.recipe.RailwaysSequencedAssemblyRecipeBuilder;
import com.railwayteam.railways.compat.tracks.TrackCompatUtils;
import com.railwayteam.railways.registry.CRItems;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.railwayteam.railways.util.TextUtils;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.kinetics.deployer.DeployerApplicationRecipe;
import com.simibubi.create.content.kinetics.deployer.ItemApplicationRecipe;
import com.simibubi.create.content.kinetics.press.PressingRecipe;
import com.simibubi.create.content.kinetics.saw.CuttingRecipe;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipeBuilder;
import com.simibubi.create.content.trains.track.TrackMaterial;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class RailwaysSequencedAssemblyRecipeGen
extends RailwaysRecipeProvider {
    final EnumMap<DyeColor, RailwaysRecipeProvider.GeneratedRecipe> CONDUCTOR_CAPS = new EnumMap(DyeColor.class);
    final Map<TrackMaterial, RailwaysRecipeProvider.GeneratedRecipe> TRACKS = new HashMap<TrackMaterial, RailwaysRecipeProvider.GeneratedRecipe>();

    public RailwaysSequencedAssemblyRecipeGen(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(output, lookupProvider);
        for (DyeColor color : DyeColor.values()) {
            String colorName = TextUtils.titleCaseConversion(color.getName().replace("_", " "));
            String colorReg = color.getName().toLowerCase(Locale.ROOT);
            this.CONDUCTOR_CAPS.put(color, this.create(colorReg + "_conductor_cap", b -> b.require((ItemLike)CRItems.woolByColor(color)).transitionTo((ItemLike)CRItems.ITEM_INCOMPLETE_CONDUCTOR_CAP.get(color).get()).addOutput((ItemLike)CRItems.ITEM_CONDUCTOR_CAP.get(color).get(), 1.0f).loops(1).addStep(CuttingRecipe::new, rb -> rb).addStep(DeployerApplicationRecipe::new, rb -> (ItemApplicationRecipe.Builder)rb.require(RailwaysRecipeProvider.Ingredients.precisionMechanism())).addStep(DeployerApplicationRecipe::new, rb -> (ItemApplicationRecipe.Builder)rb.require(RailwaysRecipeProvider.Ingredients.string()))));
        }
        ArrayList trackMaterials = new ArrayList(TrackMaterial.allFromMod((String)"railways"));
        for (String mod : TrackCompatUtils.TRACK_COMPAT_MODS) {
            trackMaterials.addAll(TrackMaterial.allFromMod((String)mod));
        }
        for (TrackMaterial material : trackMaterials) {
            if (material.railsIngredient.isEmpty() || material.sleeperIngredient.isEmpty()) {
                Ingredient sleeperIngredient;
                TrackMaterial baseMaterial;
                if (material.trackType == CRTrackMaterials.CRTrackType.WIDE_GAUGE) {
                    baseMaterial = CRTrackMaterials.getBaseFromWide(material);
                    if (baseMaterial == null || (sleeperIngredient = material == CRTrackMaterials.WIDE_GAUGE_ANDESITE ? Ingredient.of((TagKey)AllTags.AllItemTags.SLEEPERS.tag) : baseMaterial.sleeperIngredient).isEmpty()) continue;
                    this.TRACKS.put(material, this.create("track_" + (String)(material.id.getNamespace().equals("railways") ? "" : material.id.getNamespace() + "_") + material.resourceName(), b -> b.conditionalMaterial(material).require((ItemLike)baseMaterial.getBlock()).transitionTo((ItemLike)CRItems.ITEM_INCOMPLETE_TRACK.get(material).get()).addOutput((ItemLike)material.getBlock(), 1.0f).loops(1).addStep(CuttingRecipe::new, rb -> rb).addStep(DeployerApplicationRecipe::new, rb -> (ItemApplicationRecipe.Builder)rb.require(sleeperIngredient)).addStep(PressingRecipe::new, rb -> rb)));
                    continue;
                }
                if (material.trackType != CRTrackMaterials.CRTrackType.NARROW_GAUGE || (baseMaterial = CRTrackMaterials.getBaseFromNarrow(material)) == null || (sleeperIngredient = material == CRTrackMaterials.NARROW_GAUGE_ANDESITE ? Ingredient.of((TagKey)AllTags.AllItemTags.SLEEPERS.tag) : baseMaterial.sleeperIngredient).isEmpty() || baseMaterial.railsIngredient.isEmpty()) continue;
                Ingredient finalRailsIngredient = baseMaterial.railsIngredient;
                this.TRACKS.put(material, this.create("track_" + (String)(material.id.getNamespace().equals("railways") ? "" : material.id.getNamespace() + "_") + material.resourceName(), b -> b.conditionalMaterial(material).require(sleeperIngredient).transitionTo((ItemLike)CRItems.ITEM_INCOMPLETE_TRACK.get(material).get()).addOutput((ItemLike)material.getBlock(), 1.0f).loops(1).addStep(CuttingRecipe::new, rb -> rb).addStep(DeployerApplicationRecipe::new, rb -> (ItemApplicationRecipe.Builder)rb.require(finalRailsIngredient)).addStep(PressingRecipe::new, rb -> rb)));
                continue;
            }
            Ingredient finalRailsIngredient = material.railsIngredient;
            this.TRACKS.put(material, this.create("track_" + (String)(material.id.getNamespace().equals("railways") ? "" : material.id.getNamespace() + "_") + material.resourceName(), b -> b.conditionalMaterial(material).require(material.sleeperIngredient).transitionTo((ItemLike)CRItems.ITEM_INCOMPLETE_TRACK.get(material).get()).addOutput((ItemLike)material.getBlock(), 1.0f).loops(1).addStep(DeployerApplicationRecipe::new, rb -> (ItemApplicationRecipe.Builder)rb.require(finalRailsIngredient)).addStep(DeployerApplicationRecipe::new, rb -> (ItemApplicationRecipe.Builder)rb.require(finalRailsIngredient)).addStep(PressingRecipe::new, rb -> rb)));
        }
        this.TRACKS.put(CRTrackMaterials.PHANTOM, this.create("track_phantom", b -> b.require(RailwaysRecipeProvider.Ingredients.phantomMembrane()).transitionTo((ItemLike)CRItems.ITEM_INCOMPLETE_TRACK.get(CRTrackMaterials.PHANTOM).get()).addOutput(new ItemStack((ItemLike)CRTrackMaterials.PHANTOM.getBlock(), 32), 1.0f).loops(1).addStep(DeployerApplicationRecipe::new, rb -> (ItemApplicationRecipe.Builder)rb.require(RailwaysRecipeProvider.Ingredients.ironIngot())).addStep(DeployerApplicationRecipe::new, rb -> (ItemApplicationRecipe.Builder)rb.require(RailwaysRecipeProvider.Ingredients.ironIngot())).addStep(PressingRecipe::new, rb -> rb)));
        this.TRACKS.put(CRTrackMaterials.MONORAIL, this.create("track_monorail", b -> b.require(RailwaysRecipeProvider.Ingredients.girder()).transitionTo((ItemLike)CRItems.ITEM_INCOMPLETE_TRACK.get(CRTrackMaterials.MONORAIL).get()).addOutput(new ItemStack((ItemLike)CRTrackMaterials.MONORAIL.getBlock(), 6), 1.0f).loops(1).addStep(DeployerApplicationRecipe::new, rb -> (ItemApplicationRecipe.Builder)rb.require(RailwaysRecipeProvider.Ingredients.metalBracket())).addStep(DeployerApplicationRecipe::new, rb -> (ItemApplicationRecipe.Builder)rb.require(RailwaysRecipeProvider.Ingredients.ironSheet())).addStep(PressingRecipe::new, rb -> rb)));
    }

    public static RailwaysSequencedAssemblyRecipeGen create(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        return new RailwaysSequencedAssemblyRecipeGen(output, lookupProvider);
    }

    protected RailwaysRecipeProvider.GeneratedRecipe create(String name, Function<RailwaysSequencedAssemblyRecipeBuilder, SequencedAssemblyRecipeBuilder> transform) {
        RailwaysRecipeProvider.GeneratedRecipe generatedRecipe = c -> ((SequencedAssemblyRecipeBuilder)transform.apply(new RailwaysSequencedAssemblyRecipeBuilder(Railways.asResource(name)))).build(c);
        this.all.add(generatedRecipe);
        return generatedRecipe;
    }
}

