/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.client.renderer.replaced;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.monster.Creeper;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import tech.thatgravyboat.creeperoverhaul.Creepers;
import tech.thatgravyboat.creeperoverhaul.client.RenderTypes;
import tech.thatgravyboat.creeperoverhaul.client.renderer.replaced.ReplacedCreeperRenderer;
import tech.thatgravyboat.creeperoverhaul.common.entity.ReplacedCreeper;
import tech.thatgravyboat.creeperoverhaul.common.utils.Events;

public class ReplacedCreeperGlowLayer
extends GeoRenderLayer<ReplacedCreeper> {
    private static final ResourceLocation PLAINS_GLOW_TEXTURE = Creepers.id("textures/entity/plains/plains_creeper_glow.png");
    private static final ResourceLocation APRIL_GLOW_TEXTURE = Creepers.id("textures/entity/plains/plains_creeper_glow_aprilfools.png");
    private final ReplacedCreeperRenderer renderer;

    public ReplacedCreeperGlowLayer(ReplacedCreeperRenderer renderer) {
        super((GeoRenderer)renderer);
        this.renderer = renderer;
    }

    public ResourceLocation getTexture() {
        if (Creepers.EVENT == Events.APRIL_FOOLS) {
            return APRIL_GLOW_TEXTURE;
        }
        return PLAINS_GLOW_TEXTURE;
    }

    public void render(PoseStack poseStack, ReplacedCreeper animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        Creeper creeper = (Creeper)this.renderer.getCurrentEntity();
        float f = creeper.getSwelling(partialTick);
        if (f > 0.0f || creeper.isPowered()) {
            if (creeper.isPowered()) {
                f = 1.0f;
            }
            ResourceLocation texture = this.getTexture();
            VertexConsumer glowConsumer = bufferSource.getBuffer(RenderTypes.getTransparentEyes(texture));
            this.getRenderer().reRender(this.getDefaultBakedModel((GeoAnimatable)animatable), poseStack, bufferSource, (GeoAnimatable)animatable, RenderTypes.getTransparentEyes(texture), glowConsumer, partialTick, packedLight, OverlayTexture.NO_OVERLAY, 0xFFFFFF | (int)(f * 240.0f) << 24);
        }
    }
}

