/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.client.cosmetics.ui;

import com.teamresourceful.resourcefulconfig.client.components.base.ContainerWidget;
import com.teamresourceful.resourcefulconfig.client.components.base.SpriteButton;
import java.util.List;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import tech.thatgravyboat.creeperoverhaul.client.cosmetics.Cosmetic;
import tech.thatgravyboat.creeperoverhaul.client.cosmetics.service.CosmeticsApi;
import tech.thatgravyboat.creeperoverhaul.client.cosmetics.ui.CosmeticButton;

public class CosmeticGridWidget
extends ContainerWidget {
    private static final ResourceLocation NONE = ResourceLocation.fromNamespaceAndPath((String)"creeperoverhaul", (String)"none");
    private final GridLayout layout = new GridLayout().spacing(5);
    private float scrollAmount = 0.0f;

    public CosmeticGridWidget(int width, int height, List<Cosmetic> cosmetics) {
        super(0, 0, width, height);
        GridLayout.RowHelper rowHelper = this.layout.createRowHelper(Math.floorDiv(width, 35));
        rowHelper.addChild((LayoutElement)SpriteButton.builder((int)35, (int)35).tooltip((Component)Component.literal((String)"None")).sprite(NONE).onPress(() -> CosmeticsApi.setCosmetic(null)).build());
        for (Cosmetic cosmetic : cosmetics) {
            rowHelper.addChild((LayoutElement)new CosmeticButton(cosmetic));
        }
        this.layout.arrangeElements();
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    protected void positionUpdated() {
        this.layout.setPosition(this.getX(), (int)((float)this.getY() - this.scrollAmount));
        this.layout.arrangeElements();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalScroll, double verticalScroll) {
        this.scrollAmount += (float)(verticalScroll * 10.0);
        this.scrollAmount = Mth.clamp((float)this.scrollAmount, (float)0.0f, (float)Math.max(0, this.layout.getHeight() - this.getHeight()));
        this.layout.setPosition(this.getX(), (int)((float)this.getY() - this.scrollAmount));
        this.layout.arrangeElements();
        return true;
    }
}

