/*
 * Decompiled with CFR 0.152.
 */
package einstein.armortrimitemfix.data;

import einstein.armortrimitemfix.ArmorTrimItemFix;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "armortrimitemfix", existingFileHelper);
    }

    protected void registerModels() {
        ArmorTrimItemFix.TRIMMABLES.forEach((trimmable, trimmableData) -> {
            ResourceLocation trimmableKey = BuiltInRegistries.ITEM.getKey(trimmable);
            if (trimmableKey != null) {
                ResourceLocation baseTexture = trimmableKey.withPrefix("item/");
                ItemModelBuilder model = ArmorTrimItemFix.isDoubleLayered(trimmable) ? this.generatedItem(trimmableKey.toString(), baseTexture, baseTexture.withSuffix("_overlay")) : this.generatedItem(trimmableKey.toString(), baseTexture);
                for (ArmorTrimItemFix.MaterialData materialData : ArmorTrimItemFix.TRIM_MATERIALS) {
                    float materialValue = materialData.propertyValue();
                    String materialName = materialData.getName((Item)trimmable);
                    model = model.override().model((ModelFile)this.getExistingFile(ArmorTrimItemFix.vanillaOverrideName(trimmableKey, materialName))).predicate(ArmorTrimItemFix.TRIM_PATTERN_PREDICATE_ID, 0.001f).predicate(ItemModelGenerators.TRIM_TYPE_PREDICATE_ID, materialValue).end();
                    for (ResourceLocation pattern : ArmorTrimItemFix.TRIM_PATTERNS.keySet()) {
                        float patternValue = ArmorTrimItemFix.TRIM_PATTERNS.get(pattern).floatValue();
                        String patternName = pattern.getPath();
                        String name = ArmorTrimItemFix.overrideName(trimmableData, trimmableKey, patternName, materialName).toString();
                        ResourceLocation layerLoc = ArmorTrimItemFix.layerLoc(trimmableData.type(), patternName, materialName);
                        ItemModelBuilder builder = ArmorTrimItemFix.isDoubleLayered(trimmable) ? this.generatedItem(name, baseTexture, baseTexture.withSuffix("_overlay"), layerLoc) : this.generatedItem(name, baseTexture, layerLoc);
                        model = model.override().model((ModelFile)this.getExistingFile(builder.getLocation())).predicate(ArmorTrimItemFix.TRIM_PATTERN_PREDICATE_ID, patternValue).predicate(ItemModelGenerators.TRIM_TYPE_PREDICATE_ID, materialValue).end();
                    }
                }
            }
        });
    }

    private ItemModelBuilder generatedItem(String name, ResourceLocation ... layers) {
        ItemModelBuilder model = (ItemModelBuilder)this.withExistingParent(name, "item/generated");
        for (int i = 0; i < layers.length; ++i) {
            model = (ItemModelBuilder)model.texture("layer" + i, layers[i]);
        }
        return model;
    }
}

