/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.weathered_girder;

import com.kipti.bnb.content.weathered_girder.WeatheredGirderBlock;
import com.kipti.bnb.content.weathered_girder.WeatheredGirderCTBehaviour;
import com.kipti.bnb.registry.BnbPartialModels;
import com.simibubi.create.foundation.block.connected.CTModel;
import com.simibubi.create.foundation.block.connected.ConnectedTextureBehaviour;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;

public class WeatheredConnectedGirderModel
extends CTModel {
    protected static final ModelProperty<ConnectionData> CONNECTION_PROPERTY = new ModelProperty();

    public WeatheredConnectedGirderModel(BakedModel originalModel) {
        super(originalModel, (ConnectedTextureBehaviour)new WeatheredGirderCTBehaviour());
    }

    protected ModelData.Builder gatherModelData(ModelData.Builder builder, BlockAndTintGetter world, BlockPos pos, BlockState state, ModelData blockEntityData) {
        super.gatherModelData(builder, world, pos, state, blockEntityData);
        ConnectionData connectionData = new ConnectionData();
        for (Direction d : Iterate.horizontalDirections) {
            connectionData.setConnected(d, WeatheredGirderBlock.isConnected(world, pos, state, d));
        }
        return builder.with(CONNECTION_PROPERTY, (Object)connectionData);
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource rand, ModelData extraData, RenderType renderType) {
        List superQuads = super.getQuads(state, side, rand, extraData, renderType);
        if (side != null || !extraData.has(CONNECTION_PROPERTY)) {
            return superQuads;
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(superQuads);
        ConnectionData data = (ConnectionData)extraData.get(CONNECTION_PROPERTY);
        for (Direction d : Iterate.horizontalDirections) {
            if (!data.isConnected(d)) continue;
            quads.addAll(BnbPartialModels.WEATHERED_METAL_GIRDER_BRACKETS.get(d).get().getQuads(state, side, rand, extraData, renderType));
        }
        return quads;
    }

    private static class ConnectionData {
        boolean[] connectedFaces = new boolean[4];

        public ConnectionData() {
            Arrays.fill(this.connectedFaces, false);
        }

        void setConnected(Direction face, boolean connected) {
            this.connectedFaces[face.get2DDataValue()] = connected;
        }

        boolean isConnected(Direction face) {
            return this.connectedFaces[face.get2DDataValue()];
        }
    }
}

