/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.nixie.foundation;

import com.kipti.bnb.CreateBitsnBobs;
import com.kipti.bnb.content.nixie.foundation.ConfigurableDisplayOptionTransform;
import com.kipti.bnb.content.nixie.foundation.DoubleOrientedDirections;
import com.kipti.bnb.content.nixie.foundation.GenericNixieDisplayBlock;
import com.kipti.bnb.content.nixie.foundation.IGenericNixieDisplayBlock;
import com.kipti.bnb.content.nixie.nixie_board.NixieBoardBlockNixie;
import com.kipti.bnb.mixin_accessor.DynamicComponentMigrator;
import com.kipti.bnb.registry.BnbBlocks;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.DynamicComponent;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericNixieDisplayBlockEntity
extends SmartBlockEntity {
    private static final int MAX_CHARS_IN_BLOCK = 3;
    private static final Logger log = LoggerFactory.getLogger(GenericNixieDisplayBlockEntity.class);
    private Optional<DynamicComponent> customTextTop = Optional.empty();
    private Optional<DynamicComponent> customTextBottom = Optional.empty();
    private int customTextStart = 0;
    private String renderedTextTop = "";
    private String renderedTextBottom = "";
    protected ConfigurableDisplayOptions currentDisplayOption = ConfigurableDisplayOptions.NONE;

    public GenericNixieDisplayBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void initialize() {
        if (this.level.isClientSide) {
            this.updateDisplayedStrings();
        }
    }

    public void inheritDataFrom(GenericNixieDisplayBlockEntity be) {
        this.customTextTop = be.customTextTop;
        this.customTextBottom = be.customTextBottom;
        this.customTextStart = be.customTextStart;
        this.currentDisplayOption = be.currentDisplayOption;
        this.notifyUpdate();
    }

    public ConfigurableDisplayOptions getCurrentDisplayOption() {
        return this.currentDisplayOption;
    }

    public char getRenderedText(int line, int width) {
        if (line == 0) {
            if (width < this.renderedTextTop.length()) {
                return this.renderedTextTop.charAt(width);
            }
        } else if (line == 1 && width < this.renderedTextBottom.length()) {
            return this.renderedTextBottom.charAt(width);
        }
        return ' ';
    }

    public void setPositionOffset(int consumedCharsOnRow) {
        this.customTextStart = consumedCharsOnRow;
    }

    public List<ConfigurableDisplayOptions> getPossibleDisplayOptions() {
        return ((IGenericNixieDisplayBlock)this.getBlockState().getBlock()).getPossibleDisplayOptions();
    }

    public void applyToEachElementOfThisStructure(Consumer<GenericNixieDisplayBlockEntity> consumer) {
        BlockEntity blockEntity;
        GenericNixieDisplayBlockEntity controller = this.findControllerBlockEntity();
        Direction facing = (Direction)this.getBlockState().getValue((Property)GenericNixieDisplayBlock.FACING);
        Direction orientation = (Direction)this.getBlockState().getValue((Property)GenericNixieDisplayBlock.ORIENTATION);
        Direction right = DoubleOrientedDirections.getLeft(facing, orientation).getOpposite();
        BlockPos currentPos = controller.getBlockPos();
        for (int i = 0; i < 100 && (blockEntity = controller.level.getBlockEntity(currentPos)) instanceof GenericNixieDisplayBlockEntity; ++i) {
            GenericNixieDisplayBlockEntity display = (GenericNixieDisplayBlockEntity)blockEntity;
            if (!GenericNixieDisplayBlockEntity.areStatesComprableForConnection(controller.getBlockState(), display.getBlockState())) break;
            consumer.accept(display);
            currentPos = currentPos.relative(right);
        }
    }

    public void setDisplayOption(ConfigurableDisplayOptions option) {
        if (this.currentDisplayOption == option) {
            return;
        }
        this.currentDisplayOption = option;
        if (this.level.isClientSide) {
            this.updateDisplayedStrings();
        }
        this.notifyUpdate();
    }

    public static boolean areStatesComprableForConnection(BlockState state1, BlockState state2) {
        boolean stateTwoIsTube;
        if (state1 == null || state2 == null) {
            return false;
        }
        boolean stateOneIsBoard = BnbBlocks.NIXIE_BOARD.is((Object)state1.getBlock()) || BnbBlocks.DYED_NIXIE_BOARD.contains(state1.getBlock());
        boolean stateTwoIsBoard = BnbBlocks.NIXIE_BOARD.is((Object)state2.getBlock()) || BnbBlocks.DYED_NIXIE_BOARD.contains(state2.getBlock());
        boolean stateOneIsTube = BnbBlocks.LARGE_NIXIE_TUBE.is((Object)state1.getBlock()) || BnbBlocks.DYED_LARGE_NIXIE_TUBE.contains(state1.getBlock());
        boolean bl = stateTwoIsTube = BnbBlocks.LARGE_NIXIE_TUBE.is((Object)state2.getBlock()) || BnbBlocks.DYED_LARGE_NIXIE_TUBE.contains(state2.getBlock());
        if (!(stateOneIsBoard && stateTwoIsBoard || stateOneIsTube && stateTwoIsTube)) {
            return false;
        }
        if (state1.getValue((Property)GenericNixieDisplayBlock.FACING) != state2.getValue((Property)GenericNixieDisplayBlock.FACING)) {
            return false;
        }
        return state1.getValue((Property)GenericNixieDisplayBlock.ORIENTATION) == state2.getValue((Property)GenericNixieDisplayBlock.ORIENTATION);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        CompoundTag componentTag;
        super.write(tag, registries, clientPacket);
        if (this.customTextTop.isPresent()) {
            componentTag = new CompoundTag();
            this.customTextTop.get().write(componentTag, registries);
            tag.put("CustomTextComponentTop", (Tag)componentTag);
        }
        if (this.customTextBottom.isPresent()) {
            componentTag = new CompoundTag();
            this.customTextBottom.get().write(componentTag, registries);
            tag.put("CustomTextComponentBottom", (Tag)componentTag);
        }
        tag.putInt("CustomTextIndex", this.customTextStart);
        tag.putString("CurrentDisplayOption", this.currentDisplayOption.name());
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        CompoundTag componentTag;
        DynamicComponent component;
        super.read(tag, registries, clientPacket);
        if (tag.contains("CustomTextComponentTop")) {
            component = this.customTextTop.orElseGet(DynamicComponent::new);
            componentTag = tag.getCompound("CustomTextComponentTop");
            component.read(this.worldPosition, componentTag, registries);
            this.customTextTop = Optional.of(component);
        }
        if (tag.contains("CustomTextComponentBottom")) {
            component = this.customTextBottom.orElseGet(DynamicComponent::new);
            componentTag = tag.getCompound("CustomTextComponentBottom");
            component.read(this.worldPosition, componentTag, registries);
            this.customTextBottom = Optional.of(component);
        }
        this.customTextStart = tag.getInt("CustomTextIndex");
        String optionName = tag.getString("CurrentDisplayOption");
        try {
            this.currentDisplayOption = ConfigurableDisplayOptions.valueOf(optionName);
        }
        catch (IllegalArgumentException e) {
            log.warn("Invalid display option '{}' for block entity at {}. Defaulting to NONE.", (Object)optionName, (Object)this.getBlockPos());
            this.currentDisplayOption = ConfigurableDisplayOptions.NONE;
        }
        if (tag.contains("CurrentTextTop")) {
            log.info("Migrating old Nixie display data for block entity at {}", (Object)this.getBlockPos());
            String oldTextTop = tag.getString("CurrentTextTop");
            if (!oldTextTop.isEmpty()) {
                EndClipping clipping = this.getEndClipping();
                DynamicComponent component2 = new DynamicComponent();
                ((DynamicComponentMigrator)component2).bits_n_bobs$setValueToLiteral(oldTextTop, registries);
                this.customTextTop = Optional.of(component2);
                this.customTextStart = clipping.left;
            } else {
                this.customTextTop = Optional.empty();
                this.customTextStart = 0;
            }
        }
        if (tag.contains("CurrentTextBottom")) {
            log.info("Migrating old Nixie display data for block entity at {}", (Object)this.getBlockPos());
            String oldTextBottom = tag.getString("CurrentTextBottom");
            if (!oldTextBottom.isEmpty()) {
                DynamicComponent component3 = new DynamicComponent();
                ((DynamicComponentMigrator)component3).bits_n_bobs$setValueToLiteral(oldTextBottom, registries);
                this.customTextBottom = Optional.of(component3);
                EndClipping clipping = this.getEndClipping();
                this.customTextStart = clipping.left;
            } else {
                this.customTextBottom = Optional.empty();
                this.customTextStart = 0;
            }
        }
        if (clientPacket || this.isVirtual()) {
            this.updateDisplayedStrings();
        }
    }

    @NotNull
    public GenericNixieDisplayBlockEntity findControllerBlockEntity() {
        BlockEntity blockEntity;
        Direction facing = (Direction)this.getBlockState().getValue((Property)GenericNixieDisplayBlock.FACING);
        Direction orientation = (Direction)this.getBlockState().getValue((Property)GenericNixieDisplayBlock.ORIENTATION);
        Direction left = DoubleOrientedDirections.getLeft(facing, orientation);
        BlockPos leftPos = this.getBlockPos().relative(left);
        GenericNixieDisplayBlockEntity lastDisplay = this;
        for (int i = 0; i < 100 && (blockEntity = this.level.getBlockEntity(leftPos)) instanceof GenericNixieDisplayBlockEntity; ++i) {
            GenericNixieDisplayBlockEntity display = (GenericNixieDisplayBlockEntity)blockEntity;
            if (!GenericNixieDisplayBlockEntity.areStatesComprableForConnection(this.getBlockState(), display.getBlockState())) break;
            lastDisplay = display;
            leftPos = leftPos.relative(left);
        }
        return lastDisplay;
    }

    public void displayCustomText(String tagElement, int nixiePositionInRow, int line) {
        Optional<DynamicComponent> lineText;
        Optional<DynamicComponent> optional = lineText = line == 0 ? this.customTextTop : this.customTextBottom;
        if (tagElement == null) {
            return;
        }
        if (lineText.filter(d -> d.sameAs(tagElement)).isPresent()) {
            return;
        }
        DynamicComponent component = lineText.orElseGet(DynamicComponent::new);
        component.displayCustomText(this.level, this.worldPosition, tagElement);
        if (line == 0) {
            this.customTextTop = Optional.of(component);
        } else {
            this.customTextBottom = Optional.of(component);
        }
        this.customTextStart = nixiePositionInRow;
        this.notifyUpdate();
    }

    public int seekWidth() {
        Direction right = DoubleOrientedDirections.getLeft((Direction)this.getBlockState().getValue((Property)GenericNixieDisplayBlock.FACING), (Direction)this.getBlockState().getValue((Property)GenericNixieDisplayBlock.ORIENTATION)).getOpposite();
        int characterCount = 0;
        for (int i = 0; i < 100; ++i) {
            BlockPos nextPos = this.getBlockPos().relative(right, i);
            BlockEntity blockEntity = this.level.getBlockEntity(nextPos);
            if (!GenericNixieDisplayBlockEntity.areStatesComprableForConnection(this.getBlockState(), this.level.getBlockState(nextPos))) break;
            if (blockEntity instanceof GenericNixieDisplayBlockEntity) {
                GenericNixieDisplayBlockEntity currentWalkNixieDisplay = (GenericNixieDisplayBlockEntity)blockEntity;
                characterCount += currentWalkNixieDisplay.calculateDisplayedCharacterWidth();
                continue;
            }
            CreateBitsnBobs.LOGGER.warn("Found unexpected non-nixie display block entity at {} while seeking width for {}", (Object)nextPos, (Object)this.getBlockPos());
            break;
        }
        return characterCount;
    }

    public void updateDisplayedStrings() {
        this.customTextTop.map(DynamicComponent::resolve).ifPresentOrElse(fullText -> {
            this.renderedTextTop = this.charsOrEmpty((String)fullText, this.customTextStart);
        }, () -> {
            this.renderedTextTop = "";
        });
        this.customTextBottom.map(DynamicComponent::resolve).ifPresentOrElse(fullText -> {
            this.renderedTextBottom = this.charsOrEmpty((String)fullText, this.customTextStart);
        }, () -> {
            this.renderedTextBottom = "";
        });
    }

    private String charsOrEmpty(String string, int index) {
        EndClipping endClipping = this.getEndClipping();
        return " ".repeat(endClipping.left) + (string.length() <= index ? "   " : (string + " ".repeat(3)).substring(index, index + this.calculateDisplayedCharacterWidth()));
    }

    int calculateDisplayedCharacterWidth() {
        EndClipping endClipping = this.getEndClipping();
        return this.currentDisplayOption.width - endClipping.left - endClipping.right;
    }

    public EndClipping getEndClipping() {
        boolean right;
        if (!(this.getBlockState().getBlock() instanceof NixieBoardBlockNixie) || this.currentDisplayOption != ConfigurableDisplayOptions.DOUBLE_CHAR_DOUBLE_LINES) {
            return EndClipping.NONE;
        }
        boolean left = (Boolean)this.getBlockState().getValue((Property)NixieBoardBlockNixie.LEFT) == false;
        boolean bl = right = (Boolean)this.getBlockState().getValue((Property)NixieBoardBlockNixie.RIGHT) == false;
        if (left && right) {
            return EndClipping.BOTH;
        }
        if (left) {
            return EndClipping.LEFT;
        }
        if (right) {
            return EndClipping.RIGHT;
        }
        return EndClipping.NONE;
    }

    public static enum ConfigurableDisplayOptions {
        NONE(1, 1, () -> ConfigurableDisplayOptionTransform.NONE),
        ALWAYS_UP(1, 1, () -> ConfigurableDisplayOptionTransform.ALWAYS_UP),
        DOUBLE_CHAR(2, 1, () -> ConfigurableDisplayOptionTransform.DOUBLE_CHAR),
        DOUBLE_CHAR_DOUBLE_LINES(3, 2, () -> ConfigurableDisplayOptionTransform.DOUBLE_CHAR_DOUBLE_LINES);

        public final Supplier<ConfigurableDisplayOptionTransform> renderTransform;
        public final int width;
        public final int lines;

        private ConfigurableDisplayOptions(int width, int lines, Supplier<ConfigurableDisplayOptionTransform> renderTransform) {
            this.renderTransform = renderTransform;
            this.width = width;
            this.lines = lines;
        }
    }

    public static enum EndClipping {
        NONE(0, 0),
        LEFT(1, 0),
        RIGHT(0, 1),
        BOTH(1, 1);

        public final int left;
        public final int right;

        private EndClipping(int left, int right) {
            this.left = left;
            this.right = right;
        }
    }
}

