/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.nixie.foundation;

import com.kipti.bnb.CreateBitsnBobs;
import com.kipti.bnb.content.nixie.foundation.DoubleOrientedBlockModel;
import com.kipti.bnb.content.nixie.foundation.GenericNixieDisplayBlockEntity;
import com.kipti.bnb.content.nixie.foundation.GenericNixieDisplayTarget;
import com.kipti.bnb.content.nixie.nixie_board.NixieBoardBlockNixie;
import com.kipti.bnb.registry.BnbBlocks;
import com.mojang.serialization.MapCodec;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.clipboard.ClipboardEntry;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.utility.BlockHelper;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class GenericNixieDisplayBlock
extends DirectionalBlock
implements IWrenchable {
    public static final MapCodec<GenericNixieDisplayBlock> CODEC = GenericNixieDisplayBlock.simpleCodec(GenericNixieDisplayBlock::new);
    public static final DirectionProperty ORIENTATION = DirectionProperty.create((String)"orientation");

    public GenericNixieDisplayBlock(BlockBehaviour.Properties p_52591_) {
        super(p_52591_);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)ORIENTATION, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, ORIENTATION});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState stateForPlacement;
        Direction surface = context.getClickedFace();
        Direction facing = context.getNearestLookingDirection();
        if (facing.getAxis() == surface.getAxis()) {
            facing = Arrays.stream(Direction.values()).filter(dir -> dir.getAxis() != surface.getAxis()).min(Comparator.comparingDouble(dir -> Vec3.atLowerCornerOf((Vec3i)dir.getNormal()).distanceToSqr(Objects.requireNonNull(context.getPlayer()).getLookAngle()))).orElse(Direction.NORTH);
        }
        return (stateForPlacement = super.getStateForPlacement(context)) == null ? null : (BlockState)((BlockState)stateForPlacement.setValue((Property)FACING, (Comparable)surface)).setValue((Property)ORIENTATION, (Comparable)facing.getOpposite());
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        GenericNixieDisplayBlockEntity be = (GenericNixieDisplayBlockEntity)context.getLevel().getBlockEntity(context.getClickedPos());
        GenericNixieDisplayBlockEntity.ConfigurableDisplayOptions currentOption = be.getCurrentDisplayOption();
        List<GenericNixieDisplayBlockEntity.ConfigurableDisplayOptions> options = be.getPossibleDisplayOptions();
        int currentIndex = options.indexOf((Object)currentOption);
        if (currentIndex < 0) {
            CreateBitsnBobs.LOGGER.warn("No valid display option found for {}", (Object)be.getBlockPos());
            return InteractionResult.PASS;
        }
        int nextIndex = (currentIndex + 1) % options.size();
        GenericNixieDisplayBlockEntity.ConfigurableDisplayOptions nextOption = options.get(nextIndex);
        be.applyToEachElementOfThisStructure(display -> {});
        GenericNixieDisplayTarget.walkNixies(context.getLevel(), context.getClickedPos(), (TriConsumer<BlockPos, Integer, GenericNixieDisplayBlockEntity>)((TriConsumer)(currentPos, consumedCharsOnRow, blockEntity) -> {
            blockEntity.setPositionOffset((int)consumedCharsOnRow);
            blockEntity.setDisplayOption(nextOption);
        }));
        return InteractionResult.SUCCESS;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        BlockEntity blockEntity2;
        boolean display = stack.getItem() == Items.NAME_TAG && stack.has(DataComponents.CUSTOM_NAME) || AllBlocks.CLIPBOARD.isIn(stack);
        DyeColor dye = DyeColor.getColor((ItemStack)stack);
        if (!display && dye == null || !((blockEntity2 = level.getBlockEntity(pos)) instanceof GenericNixieDisplayBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        GenericNixieDisplayBlockEntity startBlockEntity = (GenericNixieDisplayBlockEntity)blockEntity2;
        if (dye != null) {
            GenericNixieDisplayTarget.walkNixies(level, pos, (TriConsumer<BlockPos, Integer, GenericNixieDisplayBlockEntity>)((TriConsumer)(currentPos, consumedCharsOnRow, initialBE) -> {
                BlockState coloredState = GenericNixieDisplayBlock.withColor(initialBE.getBlockState(), dye);
                level.setBlock(currentPos, coloredState, 3);
                BlockEntity be = level.getBlockEntity(currentPos);
                if (be instanceof GenericNixieDisplayBlockEntity) {
                    GenericNixieDisplayBlockEntity currentBe = (GenericNixieDisplayBlockEntity)be;
                    currentBe.inheritDataFrom((GenericNixieDisplayBlockEntity)((Object)initialBE));
                }
            }));
            return ItemInteractionResult.SUCCESS;
        }
        Component component = (Component)stack.getOrDefault(DataComponents.CUSTOM_NAME, (Object)Component.empty());
        MutableComponent secondRowComponent = null;
        boolean forceFromTop = false;
        if (AllBlocks.CLIPBOARD.isIn(stack)) {
            List entries = ClipboardEntry.getLastViewedEntries((ItemStack)stack);
            MutableComponent mutableComponent = component = !entries.isEmpty() ? ((ClipboardEntry)entries.getFirst()).text : Component.empty();
            if (entries.size() > 1) {
                secondRowComponent = ((ClipboardEntry)entries.get((int)1)).text;
                forceFromTop = true;
            }
        }
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        String tagUsed = Component.Serializer.toJson((Component)component, (HolderLookup.Provider)level.registryAccess());
        @Nullable String secondRowTagUsed = secondRowComponent == null ? null : Component.Serializer.toJson(secondRowComponent, (HolderLookup.Provider)level.registryAccess());
        int startLine = forceFromTop ? 0 : this.getLineForPlacement(state, pos, hitResult, level);
        GenericNixieDisplayBlockEntity.ConfigurableDisplayOptions currentDisplay = startBlockEntity.getCurrentDisplayOption();
        GenericNixieDisplayTarget.walkNixies(level, pos, (TriConsumer<BlockPos, Integer, GenericNixieDisplayBlockEntity>)((TriConsumer)(currentPos, consumedCharsOnRow, blockEntity) -> {
            if (blockEntity instanceof GenericNixieDisplayBlockEntity) {
                GenericNixieDisplayBlockEntity displayBlockEntity = blockEntity;
                if (displayBlockEntity.getCurrentDisplayOption() != currentDisplay && displayBlockEntity.getPossibleDisplayOptions().contains((Object)currentDisplay)) {
                    displayBlockEntity.setDisplayOption(currentDisplay);
                }
                displayBlockEntity.displayCustomText(tagUsed, (int)consumedCharsOnRow, startLine);
                if (secondRowTagUsed != null) {
                    displayBlockEntity.displayCustomText(secondRowTagUsed, (int)consumedCharsOnRow, 1);
                }
            }
        }));
        return ItemInteractionResult.SUCCESS;
    }

    private static BlockState withColor(BlockState state, DyeColor color) {
        if (GenericNixieDisplayBlock.isLargeNixieTube(state.getBlock())) {
            Block block = color == null ? (Block)BnbBlocks.LARGE_NIXIE_TUBE.get() : (Block)BnbBlocks.DYED_LARGE_NIXIE_TUBE.get(color).get();
            return BlockHelper.copyProperties((BlockState)state, (BlockState)block.defaultBlockState());
        }
        if (GenericNixieDisplayBlock.isNixieBoard(state.getBlock())) {
            Block block = color == null ? (Block)BnbBlocks.NIXIE_BOARD.get() : (Block)BnbBlocks.DYED_NIXIE_BOARD.get(color).get();
            return BlockHelper.copyProperties((BlockState)state, (BlockState)block.defaultBlockState());
        }
        return state;
    }

    public static boolean isLargeNixieTube(Block block) {
        return BnbBlocks.DYED_LARGE_NIXIE_TUBE.contains(block) || BnbBlocks.LARGE_NIXIE_TUBE.is((Object)block);
    }

    public static boolean isNixieBoard(Block block) {
        return BnbBlocks.DYED_NIXIE_BOARD.contains(block) || BnbBlocks.NIXIE_BOARD.is((Object)block);
    }

    private int getLineForPlacement(BlockState state, BlockPos blockPos, BlockHitResult hitResult, Level level) {
        if (!(state.getBlock() instanceof NixieBoardBlockNixie)) {
            return 0;
        }
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (!(blockEntity instanceof GenericNixieDisplayBlockEntity)) {
            return 0;
        }
        if (((GenericNixieDisplayBlockEntity)blockEntity).currentDisplayOption.lines == 1) {
            return 0;
        }
        Matrix4f rotation = DoubleOrientedBlockModel.getRotation((Direction)state.getValue((Property)FACING), (Direction)state.getValue((Property)ORIENTATION));
        Vec3 globalPos = hitResult.getLocation().subtract(blockPos.getCenter());
        Vector4f localPos = rotation.invert().transform(new Vector4f((Vector3fc)globalPos.toVector3f(), 1.0f));
        if (localPos.y < 0.0f) {
            return 1;
        }
        return 0;
    }

    @NotNull
    protected MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }
}

