/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.nixie.foundation;

import com.kipti.bnb.content.nixie.foundation.GenericNixieDisplayBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;

public enum ConfigurableDisplayOptionTransform {
    NONE(1, 1, 0.9f),
    ALWAYS_UP(1, 1, 0.9f),
    DOUBLE_CHAR(2, 1, 0.5f),
    DOUBLE_CHAR_DOUBLE_LINES(3, 2, 0.4f);

    public final int width;
    public final int lines;
    public final float scale;

    private ConfigurableDisplayOptionTransform(int width, int lines, float scale) {
        this.width = width;
        this.lines = lines;
        this.scale = scale;
    }

    public void transform(PoseStack stack, int x, int y) {
        int totalSize = 16;
        float xStep = (float)totalSize / (float)this.width;
        float yStep = (float)totalSize / (float)this.lines;
        float xOffset = xStep / 2.0f + (float)x * xStep;
        float yOffset = yStep / 2.0f + (float)y * yStep;
        stack.translate(xOffset - 8.0f, yOffset - 8.0f + (float)this.lines * 2.0f, 0.0f);
        stack.scale(this.scale, this.scale, 1.0f);
    }

    public void render(PoseStack stack, GenericNixieDisplayBlockEntity be, Consumer<Character> consumer) {
        stack.pushPose();
        for (int i = 0; i < this.lines; ++i) {
            for (int j = 0; j < this.width; ++j) {
                stack.pushPose();
                this.transform(stack, j, i);
                char glyph = be.getRenderedText(i, j);
                consumer.accept(Character.valueOf(glyph));
                stack.popPose();
            }
        }
        stack.popPose();
    }

    public boolean isMoreThanOneCharacter() {
        return this.width > 1 || this.lines > 1;
    }
}

