/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.girder_strut;

import com.kipti.bnb.content.girder_strut.GirderStrutBlock;
import com.kipti.bnb.content.girder_strut.GirderStrutModelBuilder;
import com.kipti.bnb.content.girder_strut.StrutModelType;
import com.kipti.bnb.content.girder_strut.cap.GirderCapAccumulator;
import com.kipti.bnb.content.girder_strut.mesh.GirderMeshQuad;
import com.kipti.bnb.content.girder_strut.mesh.GirderSegmentMesh;
import com.kipti.bnb.registry.BnbBlocks;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class GirderStrutModelManipulator {
    private static final Map<StrutModelType, GirderSegmentMesh> segmentMeshes = new HashMap<StrutModelType, GirderSegmentMesh>();

    private GirderStrutModelManipulator() {
    }

    static List<Consumer<BufferBuilder>> bakeConnectionToConsumer(GirderStrutModelBuilder.GirderConnection connection, StrutModelType modelType, Function<Vector3f, Integer> lightFunction) {
        if (connection.renderLength() <= (double)1.0E-4f) {
            return List.of();
        }
        GirderSegmentMesh mesh = GirderStrutModelManipulator.getSegmentMesh(modelType);
        List<GirderMeshQuad> quads = mesh.forLength((float)connection.renderLength());
        Vec3 dir = connection.direction();
        double distHorizontal = Math.sqrt(dir.x * dir.x + dir.z * dir.z);
        float yRot = distHorizontal == 0.0 ? 0.0f : (float)Math.atan2(dir.x, dir.z);
        float xRot = (float)Math.atan2(dir.y, distHorizontal);
        PoseStack poseStack = new PoseStack();
        poseStack.translate(connection.start().x, connection.start().y, connection.start().z);
        poseStack.mulPose(new Quaternionf().rotationY(yRot));
        poseStack.mulPose(new Quaternionf().rotationX(-xRot));
        poseStack.translate(-0.5f, -0.5f, -0.5f);
        PoseStack.Pose last = poseStack.last();
        Matrix4f pose = new Matrix4f((Matrix4fc)last.pose());
        Matrix3f normalMatrix = new Matrix3f((Matrix3fc)last.normal());
        Vector3f planePoint = GirderStrutModelManipulator.toVector3f(connection.surfacePlanePoint());
        Vector3f planeNormal = GirderStrutModelManipulator.toVector3f(connection.surfaceNormal());
        if (planeNormal.lengthSquared() > 1.0E-4f) {
            planeNormal.normalize();
        }
        ArrayList<Consumer<BufferBuilder>> quadConsumer = new ArrayList<Consumer<BufferBuilder>>();
        GirderCapAccumulator capAccumulator = new GirderCapAccumulator(modelType.getCapTexture());
        for (GirderMeshQuad quad : quads) {
            quad.transformAndEmitToConsumer(pose, normalMatrix, planePoint, planeNormal, capAccumulator, quadConsumer, lightFunction);
        }
        capAccumulator.emitCapsToConsumer(planeNormal, quadConsumer, lightFunction);
        return quadConsumer;
    }

    private static GirderSegmentMesh getSegmentMesh(StrutModelType modelType) {
        GirderSegmentMesh girderSegmentMesh = segmentMeshes.get((Object)modelType);
        if (girderSegmentMesh == null) {
            BakedModel bakedModel = modelType.getPartialModel().get();
            ArrayList<BakedQuad> bakedQuads = new ArrayList<BakedQuad>();
            RandomSource random = RandomSource.create();
            bakedQuads.addAll(bakedModel.getQuads(((GirderStrutBlock)((Object)BnbBlocks.GIRDER_STRUT.get())).defaultBlockState(), null, random, ModelData.EMPTY, null));
            girderSegmentMesh = new GirderSegmentMesh(bakedQuads);
            segmentMeshes.put(modelType, girderSegmentMesh);
        }
        return girderSegmentMesh;
    }

    private static Vector3f toVector3f(Vec3 vec) {
        return new Vector3f((float)vec.x, (float)vec.y, (float)vec.z);
    }

    public static void invalidateMeshes() {
        segmentMeshes.clear();
    }
}

