/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.girder_strut;

import com.kipti.bnb.content.girder_strut.GirderStrutBlockEntity;
import com.kipti.bnb.content.girder_strut.StrutModelType;
import com.kipti.bnb.registry.BnbBlockEntities;
import com.kipti.bnb.registry.BnbShapes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GirderStrutBlock
extends Block
implements IBE<GirderStrutBlockEntity>,
SimpleWaterloggedBlock,
IWrenchable {
    public static final DirectionProperty FACING = DirectionalBlock.FACING;
    public static final int MAX_SPAN = 8;
    private StrutModelType modelType;

    public GirderStrutBlock(BlockBehaviour.Properties properties, StrutModelType modelType) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.modelType = modelType;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        return InteractionResult.PASS;
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Player player = context.getPlayer();
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        if (!level.isClientSide) {
            BlockState currentState = level.getBlockState(pos);
            ItemStack itemToReturn = new ItemStack((ItemLike)currentState.getBlock());
            this.destroyConnectedStrut(level, pos, false);
            if (player != null && !player.hasInfiniteMaterials()) {
                player.getInventory().placeItemBackInInventory(itemToReturn);
            }
        }
        return super.onSneakWrenched(state, context);
    }

    public static NonNullFunction<BlockBehaviour.Properties, GirderStrutBlock> normal() {
        return properties -> new GirderStrutBlock((BlockBehaviour.Properties)properties, StrutModelType.NORMAL);
    }

    public static NonNullFunction<BlockBehaviour.Properties, GirderStrutBlock> weathered() {
        return properties -> new GirderStrutBlock((BlockBehaviour.Properties)properties, StrutModelType.WEATHERED);
    }

    @NotNull
    public BlockState updateShape(BlockState state, @NotNull Direction direction, @NotNull BlockState neighbourState, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockPos neighbourPos) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return state;
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, BlockStateProperties.WATERLOGGED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        FluidState ifluidstate = level.getFluidState(pos);
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        return (BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)context.getClickedFace())).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.getType() == Fluids.WATER));
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return BnbShapes.GIRDER_STRUT.get((Direction)state.getValue((Property)FACING));
    }

    public PushReaction getPistonPushReaction(@NotNull BlockState state) {
        return PushReaction.NORMAL;
    }

    @NotNull
    public BlockState playerWillDestroy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, Player player) {
        boolean shouldPreventDrops = player.hasInfiniteMaterials();
        if (shouldPreventDrops && !level.isClientSide) {
            this.destroyConnectedStrut(level, pos, false);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    private void destroyConnectedStrut(Level level, BlockPos pos, boolean dropBlock) {
        this.withBlockEntityDo((BlockGetter)level, pos, gbe -> {
            for (BlockPos otherPos : gbe.getConnectionsCopy()) {
                BlockEntity otherBe = level.getBlockEntity(otherPos = otherPos.offset((Vec3i)pos));
                if (!(otherBe instanceof GirderStrutBlockEntity)) continue;
                GirderStrutBlockEntity other = (GirderStrutBlockEntity)otherBe;
                other.removeConnection(pos);
                if (other.connectionCount() != 0) continue;
                level.destroyBlock(otherPos, dropBlock);
            }
        });
    }

    public void onRemove(BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock()) && !level.isClientSide) {
            this.destroyConnectedStrut(level, pos, true);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public Class<GirderStrutBlockEntity> getBlockEntityClass() {
        return GirderStrutBlockEntity.class;
    }

    public BlockEntityType<? extends GirderStrutBlockEntity> getBlockEntityType() {
        return (BlockEntityType)BnbBlockEntities.GIRDER_STRUT.get();
    }

    public StrutModelType getModelType() {
        return this.modelType;
    }

    public void setModelType(StrutModelType modelType) {
        this.modelType = modelType;
    }
}

