/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.cogwheel_chain.item;

import com.kipti.bnb.content.cogwheel_chain.graph.CogwheelChainPathfinder;
import com.kipti.bnb.content.cogwheel_chain.graph.PlacingCogwheelChain;
import com.kipti.bnb.content.cogwheel_chain.graph.PlacingCogwheelNode;
import com.kipti.bnb.content.cogwheel_chain.item.CogwheelChainPlacementInteraction;
import com.simibubi.create.content.equipment.blueprint.BlueprintOverlayRenderer;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import java.util.concurrent.atomic.AtomicInteger;
import net.createmod.catnip.outliner.Outliner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class CogwheelChainPlacementEffect {
    private static final float PARTICLE_DENSITY = 0.1f;

    public static void tick(LocalPlayer player) {
        ItemStack heldItem;
        if (Minecraft.getInstance().isPaused() || Minecraft.getInstance().hitResult == null) {
            return;
        }
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null || CogwheelChainPlacementInteraction.currentChainLevel == null || CogwheelChainPlacementInteraction.currentBuildingChain == null) {
            return;
        }
        if (!CogwheelChainPlacementInteraction.currentChainLevel.equals((Object)level.dimension()) || !CogwheelChainPlacementInteraction.currentBuildingChain.checkMatchingNodesInLevel((Level)level)) {
            CogwheelChainPlacementInteraction.currentBuildingChain = null;
            CogwheelChainPlacementInteraction.currentChainLevel = null;
            return;
        }
        Object object = CogwheelChainPlacementEffect.isChain(player.getMainHandItem()) ? player.getMainHandItem() : (heldItem = CogwheelChainPlacementEffect.isChain(player.getOffhandItem()) ? player.getOffhandItem() : null);
        if (heldItem != null) {
            BlockPos targetedPos = CogwheelChainPlacementEffect.getTargetedBlockAndDisplay();
            if (!player.hasInfiniteMaterials()) {
                double additionalDistance = targetedPos != null ? Vec3.atLowerCornerOf((Vec3i)targetedPos.subtract((Vec3i)CogwheelChainPlacementInteraction.currentBuildingChain.getLastNode().pos())).length() : 0.0;
                int chainsRequired = CogwheelChainPlacementInteraction.currentBuildingChain.getChainsRequired(additionalDistance);
                boolean hasEnough = ChainConveyorBlockEntity.getChainsFromInventory((Player)player, (ItemStack)Items.CHAIN.getDefaultInstance(), (int)chainsRequired, (boolean)true);
                BlueprintOverlayRenderer.displayChainRequirements((Item)Items.CHAIN, (int)chainsRequired, (boolean)hasEnough);
            }
        }
    }

    private static boolean isChain(ItemStack offhandItem) {
        return offhandItem.is(Items.CHAIN);
    }

    @Nullable
    private static BlockPos getTargetedBlockAndDisplay() {
        if (CogwheelChainPlacementInteraction.currentBuildingChain == null) {
            return null;
        }
        ClientLevel level = Minecraft.getInstance().level;
        HitResult genericHit = Minecraft.getInstance().hitResult;
        if (!(genericHit instanceof BlockHitResult)) {
            return null;
        }
        BlockHitResult hit = (BlockHitResult)genericHit;
        PlacingCogwheelNode lastNode = CogwheelChainPlacementInteraction.currentBuildingChain.getLastNode();
        Vec3 lastNodePos = Vec3.atCenterOf((Vec3i)lastNode.pos());
        Direction.Axis axis = lastNode.rotationAxis();
        Vec3 targetedOrigin = hit.getLocation();
        Vec3 toTargeted = targetedOrigin.subtract(lastNodePos);
        Vec3 axisNormal = Vec3.atLowerCornerOf((Vec3i)Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis).getNormal());
        Vec3 projected = toTargeted.subtract(axisNormal.scale(toTargeted.dot(axisNormal))).add(lastNodePos);
        for (int i = 0; i < CogwheelChainPlacementInteraction.currentBuildingChain.getSize(); ++i) {
            CogwheelChainPlacementEffect.showBlockOutline(level, CogwheelChainPlacementInteraction.currentBuildingChain.getNodes().get(i).pos());
        }
        for (int side = -1; side <= 1; side += 2) {
            for (int i = 0; i < CogwheelChainPlacementInteraction.currentBuildingChain.getSize() - 1; ++i) {
                Vec3 pathingTangentA;
                Vec3 pathingTangentB;
                PlacingCogwheelNode nodeB;
                PlacingCogwheelNode nodeA = CogwheelChainPlacementInteraction.currentBuildingChain.getNodes().get(i);
                if (CogwheelChainPathfinder.isValidPathStep(nodeA, side, nodeB = CogwheelChainPlacementInteraction.currentBuildingChain.getNodes().get(i + 1), side)) {
                    pathingTangentB = CogwheelChainPathfinder.getPathingTangentOnCog(nodeA, nodeB, side);
                    pathingTangentA = CogwheelChainPathfinder.getPathingTangentOnCog(nodeB, nodeA, -side);
                    Outliner.getInstance().showLine((Object)("cogwheel_chain_placement_pathing_" + String.valueOf(nodeA.pos()) + "_" + String.valueOf(nodeB.pos()) + "_side_" + side), nodeA.center().add(pathingTangentA), nodeB.center().add(pathingTangentB)).colored(9817409).lineWidth(0.0625f);
                    continue;
                }
                if (!CogwheelChainPathfinder.isValidPathStep(nodeA, side, nodeB, -side)) continue;
                pathingTangentB = CogwheelChainPathfinder.getPathingTangentOnCog(nodeA, nodeB, -side);
                pathingTangentA = CogwheelChainPathfinder.getPathingTangentOnCog(nodeB, nodeA, -side);
                Outliner.getInstance().showLine((Object)("cogwheel_chain_placement_pathing_" + String.valueOf(nodeA.pos()) + "_" + String.valueOf(nodeB.pos()) + "_side_" + side + "_switching"), nodeA.center().add(pathingTangentA), nodeB.center().add(pathingTangentB)).colored(9817409).lineWidth(0.0625f);
            }
        }
        Vec3 lastPos = CogwheelChainPlacementInteraction.currentBuildingChain.getLastNode().center();
        CogwheelChainPlacementEffect.renderParticlesBetween(level, lastPos, projected);
        BlockPos targetedPos = hit.getBlockPos();
        BlockState targetedState = level.getBlockState(targetedPos);
        return PlacingCogwheelChain.isValidBlockTarget(targetedState) ? targetedPos : null;
    }

    private static void showBlockOutline(ClientLevel level, BlockPos pos) {
        AtomicInteger counter = new AtomicInteger(0);
        level.getBlockState(pos).getShape((BlockGetter)level, pos).forAllEdges((fx, fy, fz, tx, ty, tz) -> Outliner.getInstance().showLine((Object)("cogwheel_chain_placement_" + String.valueOf(pos) + "_outline_" + counter.getAndIncrement()), new Vec3(fx, fy, fz).add(Vec3.atLowerCornerOf((Vec3i)pos)), new Vec3(tx, ty, tz).add(Vec3.atLowerCornerOf((Vec3i)pos))).colored(9817409).lineWidth(0.0625f));
    }

    private static void renderParticlesBetween(ClientLevel level, Vec3 from, Vec3 to) {
        Vec3 delta = to.subtract(from);
        double length = delta.length();
        if (length < 0.001 || length > 256.0) {
            return;
        }
        Vec3 dir = delta.normalize();
        double step = 0.25;
        for (double t = 0.0; t <= length; t += 0.25) {
            if (level.getRandom().nextFloat() > 0.1f) continue;
            Vec3 lerped = from.add(dir.scale(t));
            level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(0.66796875f, 0.8984375f, 0.32421875f), 1.0f), true, lerped.x, lerped.y, lerped.z, 0.0, 0.0, 0.0);
        }
    }
}

